/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.google.common.base.Function;
import com.spotify.ffwd.http.netflix.servo.monitor.CompositeMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitor;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.tag.TagList;
import com.spotify.ffwd.http.netflix.servo.tag.TaggingContext;
import com.spotify.ffwd.http.netflix.servo.util.UnmodifiableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractContextualMonitor<T, M extends Monitor<T>>
implements CompositeMonitor<T> {
    protected final MonitorConfig baseConfig;
    protected final TaggingContext context;
    protected final Function<MonitorConfig, M> newMonitor;
    protected final ConcurrentMap<MonitorConfig, M> monitors;

    protected AbstractContextualMonitor(MonitorConfig baseConfig, TaggingContext context, Function<MonitorConfig, M> newMonitor) {
        this.baseConfig = baseConfig;
        this.context = context;
        this.newMonitor = newMonitor;
        this.monitors = new ConcurrentHashMap<MonitorConfig, M>();
    }

    @Override
    public T getValue() {
        return this.getValue(0);
    }

    protected M getMonitorForCurrentContext() {
        Monitor newMon;
        MonitorConfig contextConfig = this.getConfig();
        Monitor monitor = (Monitor)this.monitors.get(contextConfig);
        if (monitor == null && (monitor = this.monitors.putIfAbsent(contextConfig, newMon = (Monitor)this.newMonitor.apply(contextConfig))) == null) {
            monitor = newMon;
        }
        return (M)monitor;
    }

    @Override
    public MonitorConfig getConfig() {
        TagList contextTags = this.context.getTags();
        return MonitorConfig.builder(this.baseConfig.getName()).withTags(this.baseConfig.getTags()).withTags(contextTags).build();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return UnmodifiableList.copyOf(this.monitors.values());
    }
}

