/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.monitor.AbstractMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.CompositeMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitor;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.util.UnmodifiableList;
import java.util.List;

public final class BasicCompositeMonitor
extends AbstractMonitor<Integer>
implements CompositeMonitor<Integer> {
    private final List<Monitor<?>> monitors;

    public BasicCompositeMonitor(MonitorConfig config, List<Monitor<?>> monitors) {
        super(config);
        this.monitors = UnmodifiableList.copyOf(monitors);
    }

    @Override
    public Integer getValue(int pollerIdx) {
        return this.monitors.size();
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicCompositeMonitor)) {
            return false;
        }
        BasicCompositeMonitor m = (BasicCompositeMonitor)obj;
        return this.config.equals(m.getConfig()) && this.monitors.equals(m.getMonitors());
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.monitors.hashCode();
        return result;
    }

    public String toString() {
        return "BasicCompositeMonitor{config=" + this.config + ", monitors=" + this.monitors + '}';
    }
}

