/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.monitor.AbstractMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Gauge;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.util.Throwables;
import java.util.concurrent.Callable;

public final class BasicGauge<T extends Number>
extends AbstractMonitor<T>
implements Gauge<T> {
    private final Callable<T> function;

    public BasicGauge(MonitorConfig config, Callable<T> function) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.function = function;
    }

    @Override
    public T getValue(int pollerIndex) {
        try {
            return (T)((Number)this.function.call());
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicGauge)) {
            return false;
        }
        BasicGauge m = (BasicGauge)obj;
        return this.config.equals(m.getConfig()) && this.function.equals(m.function);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }

    public String toString() {
        return "BasicGauge{config=" + this.config + ", function=" + this.function + '}';
    }
}

