/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public final class BucketConfig {
    private final TimeUnit timeUnit;
    private final long[] buckets;

    private BucketConfig(Builder builder) {
        this.timeUnit = builder.timeUnit;
        this.buckets = Arrays.copyOf(builder.buckets, builder.buckets.length);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getTimeUnitAbbreviation() {
        switch (this.timeUnit) {
            case DAYS: {
                return "day";
            }
            case HOURS: {
                return "hr";
            }
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MINUTES: {
                return "min";
            }
            case NANOSECONDS: {
                return "ns";
            }
            case SECONDS: {
                return "s";
            }
        }
        return "unkwn";
    }

    public long[] getBuckets() {
        return Arrays.copyOf(this.buckets, this.buckets.length);
    }

    public String toString() {
        return "BucketConfig{timeUnit=" + (Object)((Object)this.timeUnit) + ", buckets=" + Arrays.toString(this.buckets) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketConfig)) {
            return false;
        }
        BucketConfig that = (BucketConfig)o;
        return this.timeUnit == that.timeUnit && Arrays.equals(this.buckets, that.buckets);
    }

    public int hashCode() {
        int result = this.timeUnit.hashCode();
        result = 31 * result + Arrays.hashCode(this.buckets);
        return result;
    }

    public static class Builder {
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private long[] buckets = null;

        public Builder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = Preconditions.checkNotNull(timeUnit, "timeUnit");
            return this;
        }

        public Builder withBuckets(long[] buckets) {
            Preconditions.checkNotNull(buckets, "buckets");
            this.buckets = Arrays.copyOf(buckets, buckets.length);
            Preconditions.checkArgument(this.buckets.length > 0, "buckets cannot be empty");
            Preconditions.checkArgument(this.isAscending(this.buckets), "buckets must be in ascending order");
            return this;
        }

        private boolean isAscending(long[] values) {
            long last = values[0];
            for (int i = 1; i < values.length; ++i) {
                if (values[i] <= last) {
                    return false;
                }
                last = values[i];
            }
            return true;
        }

        public BucketConfig build() {
            return new BucketConfig(this);
        }
    }
}

