/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

final class Datapoint {
    static final Datapoint UNKNOWN = new Datapoint(0L, -1L);
    private final long timestamp;
    private final long value;

    Datapoint(long timestamp, long value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    boolean isUnknown() {
        return this.timestamp == 0L;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint dp = (Datapoint)obj;
        return this.timestamp == dp.timestamp && this.value == dp.value;
    }

    public String toString() {
        return "Datapoint{timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

