/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.monitor.AbstractMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Gauge;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.monitor.Pollers;
import com.spotify.ffwd.http.netflix.servo.monitor.StepLong;
import com.spotify.ffwd.http.netflix.servo.util.Clock;
import com.spotify.ffwd.http.netflix.servo.util.ClockWithOffset;
import java.util.concurrent.atomic.AtomicLong;

public class MinGauge
extends AbstractMonitor<Long>
implements Gauge<Long> {
    private final StepLong min;

    public MinGauge(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    MinGauge(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.min = new StepLong(Long.MAX_VALUE, clock);
    }

    private void updateMin(int idx, long v) {
        AtomicLong current = this.min.getCurrent(idx);
        long m = current.get();
        while (v < m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    public void update(long v) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updateMin(i, v);
        }
    }

    @Override
    public Long getValue(int pollerIdx) {
        long v = this.min.poll(pollerIdx).getValue();
        return v == Long.MAX_VALUE ? 0L : v;
    }

    public long getCurrentValue(int nth) {
        long v = this.min.getCurrent(nth).get();
        return v == Long.MAX_VALUE ? 0L : v;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MinGauge)) {
            return false;
        }
        MinGauge m = (MinGauge)obj;
        return this.config.equals(m.getConfig()) && this.getValue(0).equals(m.getValue(0));
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.getValue(0).hashCode();
        return result;
    }

    public String toString() {
        return "MinGauge{config=" + this.config + ", min=" + this.min + '}';
    }
}

