/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.monitor.AbstractMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Gauge;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import java.lang.ref.WeakReference;

public class NumberGauge
extends AbstractMonitor<Number>
implements Gauge<Number> {
    private final WeakReference<Number> numberRef;

    public NumberGauge(MonitorConfig config, Number number) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        Preconditions.checkNotNull(number, "number");
        this.numberRef = new WeakReference<Number>(number);
    }

    @Override
    public Number getValue(int pollerIdx) {
        Number n = (Number)this.numberRef.get();
        return n != null ? (Number)n : (Number)Double.NaN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberGauge)) {
            return false;
        }
        NumberGauge that = (NumberGauge)o;
        return this.config.equals(that.config) && ((Number)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.getValue(0).hashCode();
        return result;
    }

    public String toString() {
        return "NumberGauge{config=" + this.config + ", number=" + this.numberRef.get() + '}';
    }

    protected Number getBackingNumber() {
        return (Number)this.numberRef.get();
    }
}

