/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.monitor.AbstractMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Counter;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.monitor.Pollers;
import com.spotify.ffwd.http.netflix.servo.monitor.StepLong;
import com.spotify.ffwd.http.netflix.servo.util.Clock;
import com.spotify.ffwd.http.netflix.servo.util.ClockWithOffset;
import java.util.concurrent.atomic.AtomicLong;

public class PeakRateCounter
extends AbstractMonitor<Number>
implements Counter {
    private final Clock clock;
    private final AtomicLong currentSecond = new AtomicLong();
    private final AtomicLong currentCount = new AtomicLong();
    private final StepLong peakRate;

    public PeakRateCounter(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    PeakRateCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.clock = clock;
        this.peakRate = new StepLong(0L, clock);
    }

    @Override
    public Number getValue(int pollerIdx) {
        return this.peakRate.getCurrent(pollerIdx);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PeakRateCounter)) {
            return false;
        }
        PeakRateCounter c = (PeakRateCounter)obj;
        double v = ((Number)this.getValue()).doubleValue();
        double otherV = ((Number)c.getValue()).doubleValue();
        return this.config.equals(c.getConfig()) && Double.compare(v, otherV) == 0;
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        long n = Double.doubleToLongBits(((Number)this.getValue()).doubleValue());
        result = 31 * result + (int)(n ^ n >>> 32);
        return result;
    }

    public String toString() {
        return "PeakRateCounter{config=" + this.config + ", max rate per second=" + this.getValue() + '}';
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    private void updatePeakPoller(int idx, long v) {
        AtomicLong current = this.peakRate.getCurrent(idx);
        long m = current.get();
        while (v > m && !current.compareAndSet(m, v)) {
            m = current.get();
        }
    }

    private void updatePeak(long v) {
        for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
            this.updatePeakPoller(i, v);
        }
    }

    @Override
    public void increment(long amount) {
        long now = this.clock.now() / 1000L;
        if (now != this.currentSecond.get()) {
            this.currentCount.set(0L);
            this.currentSecond.set(now);
        }
        long count = this.currentCount.addAndGet(amount);
        this.updatePeak(count);
    }
}

