/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.monitor;

import com.spotify.ffwd.http.netflix.servo.monitor.BasicTimer;
import com.spotify.ffwd.http.netflix.servo.monitor.CompositeMonitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitor;
import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.monitor.Stopwatch;
import com.spotify.ffwd.http.netflix.servo.monitor.Timer;
import com.spotify.ffwd.http.netflix.servo.tag.BasicTagList;
import com.spotify.ffwd.http.netflix.servo.tag.TagList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TimedInterface {
    static final String TIMED_INTERFACE = "TimedInterface";
    static final String INTERFACE_TAG = "interface";
    static final String CLASS_TAG = "class";
    static final String ID_TAG = "id";

    private TimedInterface() {
    }

    public static <T> T newProxy(Class<T> ctype, T concrete, String id) {
        TimedHandler<T> handler = new TimedHandler<T>(ctype, concrete, id);
        Class[] types = new Class[]{ctype, CompositeMonitor.class};
        return (T)Proxy.newProxyInstance(ctype.getClassLoader(), types, handler);
    }

    public static <T> T newProxy(Class<T> ctype, T concrete) {
        return TimedInterface.newProxy(ctype, concrete, null);
    }

    private static class TimedHandler<T>
    implements InvocationHandler,
    CompositeMonitor<Long> {
        private final T concrete;
        private final Map<String, Timer> timers;
        private final MonitorConfig baseConfig;
        private final TagList baseTagList;

        @Override
        public List<Monitor<?>> getMonitors() {
            ArrayList dynamicTimers = new ArrayList();
            for (Timer timer : this.timers.values()) {
                dynamicTimers.add(timer);
            }
            return dynamicTimers;
        }

        @Override
        public Long getValue(int pollerIdx) {
            return this.timers.size();
        }

        @Override
        public Long getValue() {
            return this.getValue(0);
        }

        @Override
        public MonitorConfig getConfig() {
            return this.baseConfig;
        }

        TimedHandler(Class<T> ctype, T concrete, String id) {
            this.concrete = concrete;
            BasicTagList tagList = BasicTagList.of(TimedInterface.INTERFACE_TAG, ctype.getSimpleName(), TimedInterface.CLASS_TAG, concrete.getClass().getSimpleName());
            if (id != null) {
                tagList = tagList.copy(TimedInterface.ID_TAG, id);
            }
            this.baseTagList = tagList;
            this.baseConfig = MonitorConfig.builder(TimedInterface.TIMED_INTERFACE).withTags(this.baseTagList).build();
            this.timers = new HashMap<String, Timer>();
            for (Method method : ctype.getMethods()) {
                MonitorConfig config = MonitorConfig.builder(method.getName()).withTags(this.baseTagList).build();
                this.timers.put(method.getName(), new BasicTimer(config));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<CompositeMonitor> declaringClass = method.getDeclaringClass();
            if (declaringClass.isAssignableFrom(CompositeMonitor.class)) {
                return method.invoke((Object)this, args);
            }
            String methodName = method.getName();
            Timer timer = this.timers.get(methodName);
            Stopwatch stopwatch = timer.start();
            try {
                Object object = method.invoke(this.concrete, args);
                return object;
            }
            finally {
                stopwatch.stop();
            }
        }
    }
}

