/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.publish;

import com.spotify.ffwd.http.netflix.servo.Metric;
import com.spotify.ffwd.http.netflix.servo.monitor.Counter;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitors;
import com.spotify.ffwd.http.netflix.servo.publish.BaseMetricObserver;
import com.spotify.ffwd.http.netflix.servo.publish.MetricObserver;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMetricObserver.class);
    private final MetricObserver wrappedObserver;
    private final long expireTime;
    private final BlockingQueue<TimestampedUpdate> updateQueue;
    private volatile boolean stopUpdateThread = false;
    private final Thread processingThread;
    private final Counter expiredUpdateCount = Monitors.newCounter("expiredUpdateCount");

    public AsyncMetricObserver(String name, MetricObserver observer, int queueSize, long expireTime) {
        super(name);
        this.expireTime = expireTime;
        this.wrappedObserver = Preconditions.checkNotNull(observer, "observer");
        Preconditions.checkArgument(queueSize >= 1, String.format("invalid queueSize %d, size must be >= 1", queueSize));
        this.updateQueue = new LinkedBlockingDeque<TimestampedUpdate>(queueSize);
        String threadName = this.getClass().getSimpleName() + "-" + name;
        this.processingThread = new Thread((Runnable)new UpdateProcessor(), threadName);
        this.processingThread.setDaemon(true);
        this.processingThread.start();
    }

    public AsyncMetricObserver(String name, MetricObserver observer) {
        this(name, observer, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    public AsyncMetricObserver(String name, MetricObserver observer, int queueSize) {
        this(name, observer, queueSize, Long.MAX_VALUE);
    }

    @Override
    public void updateImpl(List<Metric> metrics) {
        long now = System.currentTimeMillis();
        TimestampedUpdate update = new TimestampedUpdate(now, metrics);
        boolean result = this.updateQueue.offer(update);
        int maxAttempts = 5;
        for (int attempts = 0; !result && attempts < 5; ++attempts) {
            this.updateQueue.remove();
            result = this.updateQueue.offer(update);
        }
        if (!result) {
            this.incrementFailedCount();
        }
    }

    public void stop() {
        this.stopUpdateThread = true;
        this.processingThread.interrupt();
    }

    private void processUpdate() {
        try {
            TimestampedUpdate update = this.updateQueue.take();
            long cutoff = System.currentTimeMillis() - this.expireTime;
            if (update.getTimestamp() < cutoff) {
                this.expiredUpdateCount.increment();
                return;
            }
            this.wrappedObserver.update(update.getMetrics());
        }
        catch (InterruptedException ie) {
            LOGGER.warn("interrupted while adding to queue, update dropped");
            this.incrementFailedCount();
        }
        catch (Throwable t) {
            LOGGER.warn("update failed for downstream queue", t);
            this.incrementFailedCount();
        }
    }

    private static class TimestampedUpdate {
        private final long timestamp;
        private final List<Metric> metrics;

        public TimestampedUpdate(long timestamp, List<Metric> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        List<Metric> getMetrics() {
            return this.metrics;
        }
    }

    private class UpdateProcessor
    implements Runnable {
        private UpdateProcessor() {
        }

        @Override
        public void run() {
            while (!AsyncMetricObserver.this.stopUpdateThread) {
                AsyncMetricObserver.this.processUpdate();
            }
        }
    }
}

