/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.publish;

import com.spotify.ffwd.http.netflix.servo.Metric;
import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.annotations.Monitor;
import com.spotify.ffwd.http.netflix.servo.annotations.MonitorTags;
import com.spotify.ffwd.http.netflix.servo.publish.MetricObserver;
import com.spotify.ffwd.http.netflix.servo.tag.BasicTagList;
import com.spotify.ffwd.http.netflix.servo.tag.StandardTagKeys;
import com.spotify.ffwd.http.netflix.servo.tag.Tag;
import com.spotify.ffwd.http.netflix.servo.tag.TagList;
import com.spotify.ffwd.http.netflix.servo.tag.Tags;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import com.spotify.ffwd.http.netflix.servo.util.Throwables;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseMetricObserver
implements MetricObserver {
    @MonitorTags
    private final TagList tags;
    private final String name;
    @Monitor(name="updateCount", type=DataSourceType.COUNTER)
    private final AtomicInteger updateCount = new AtomicInteger(0);
    @Monitor(name="updateFailureCount", type=DataSourceType.COUNTER)
    private final AtomicInteger failedUpdateCount = new AtomicInteger(0);

    public BaseMetricObserver(String name) {
        Tag id = Tags.newTag(StandardTagKeys.MONITOR_ID.getKeyName(), name);
        this.name = Preconditions.checkNotNull(name, "name");
        this.tags = BasicTagList.of(id);
    }

    public abstract void updateImpl(List<Metric> var1);

    @Override
    public final void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics, "metrics");
        try {
            this.updateImpl(metrics);
        }
        catch (Throwable t) {
            this.failedUpdateCount.incrementAndGet();
            throw Throwables.propagate(t);
        }
        finally {
            this.updateCount.incrementAndGet();
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void incrementFailedCount() {
        this.failedUpdateCount.incrementAndGet();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    public int getFailedUpdateCount() {
        return this.failedUpdateCount.get();
    }
}

