/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.publish;

import com.spotify.ffwd.http.netflix.servo.Metric;
import com.spotify.ffwd.http.netflix.servo.publish.BaseMetricObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MemoryMetricObserver
extends BaseMetricObserver {
    private static final int DEFAULT_N = 10;
    private final List<Metric>[] observations;
    private int next;

    public MemoryMetricObserver() {
        this("unamed observer", 10);
    }

    public MemoryMetricObserver(String name, int num) {
        super(name);
        this.observations = new List[num];
        this.next = 0;
    }

    @Override
    public void updateImpl(List<Metric> metrics) {
        this.observations[this.next] = metrics;
        this.next = (this.next + 1) % this.observations.length;
    }

    public List<List<Metric>> getObservations() {
        ArrayList<List<Metric>> builder = new ArrayList<List<Metric>>();
        int pos = this.next;
        for (List<Metric> ignored : this.observations) {
            if (this.observations[pos] != null) {
                builder.add(this.observations[pos]);
            }
            pos = (pos + 1) % this.observations.length;
        }
        return Collections.unmodifiableList(builder);
    }
}

