/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.publish;

import com.spotify.ffwd.http.netflix.servo.Metric;
import com.spotify.ffwd.http.netflix.servo.publish.MetricFilter;
import com.spotify.ffwd.http.netflix.servo.publish.MetricObserver;
import com.spotify.ffwd.http.netflix.servo.publish.MetricPoller;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import com.spotify.ffwd.http.netflix.servo.util.UnmodifiableList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollRunnable.class);
    private final MetricPoller poller;
    private final MetricFilter filter;
    private final boolean reset;
    private final List<MetricObserver> observers;

    public PollRunnable(MetricPoller poller, MetricFilter filter, Collection<MetricObserver> observers) {
        this(poller, filter, false, observers);
    }

    public PollRunnable(MetricPoller poller, MetricFilter filter, boolean reset, Collection<MetricObserver> observers) {
        this.poller = Preconditions.checkNotNull(poller, "poller");
        this.filter = Preconditions.checkNotNull(filter, "poller");
        this.reset = reset;
        this.observers = UnmodifiableList.copyOf(observers);
    }

    public PollRunnable(MetricPoller poller, MetricFilter filter, MetricObserver ... observers) {
        this(poller, filter, false, UnmodifiableList.copyOf(observers));
    }

    @Override
    public void run() {
        try {
            List<Metric> metrics = this.poller.poll(this.filter, this.reset);
            for (MetricObserver o : this.observers) {
                try {
                    o.update(metrics);
                }
                catch (Throwable t) {
                    LOGGER.warn("failed to send metrics to " + o.getName(), t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("failed to poll metrics", t);
        }
    }
}

