/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.publish;

import com.spotify.ffwd.http.netflix.servo.publish.PollRunnable;
import com.spotify.ffwd.http.netflix.servo.util.ThreadFactories;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class PollScheduler {
    private static final PollScheduler INSTANCE = new PollScheduler();
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference();

    public static PollScheduler getInstance() {
        return INSTANCE;
    }

    private PollScheduler() {
    }

    public void addPoller(PollRunnable task, long delay, TimeUnit timeUnit) {
        ScheduledExecutorService service = this.executor.get();
        if (service == null) {
            throw new IllegalStateException("you must start the scheduler before tasks can be submitted");
        }
        service.scheduleWithFixedDelay(task, 0L, delay, timeUnit);
    }

    public void start() {
        int numThreads = Runtime.getRuntime().availableProcessors();
        ThreadFactory factory = ThreadFactories.withName("ServoPollScheduler-%d");
        this.start(Executors.newScheduledThreadPool(numThreads, factory));
    }

    public void start(ScheduledExecutorService service) {
        if (!this.executor.compareAndSet(null, service)) {
            throw new IllegalStateException("cannot start scheduler again without stopping it");
        }
    }

    public void stop() {
        ScheduledExecutorService service = this.executor.get();
        if (service == null || !this.executor.compareAndSet(service, null)) {
            throw new IllegalStateException("scheduler must be started before you stop it");
        }
        service.shutdown();
    }

    public boolean isStarted() {
        return this.executor.get() != null;
    }
}

