/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.stats;

import java.util.Arrays;

public final class StatsConfig {
    private static final String CLASS_NAME = StatsConfig.class.getCanonicalName();
    private static final String SIZE_PROP = CLASS_NAME + ".sampleSize";
    private static final String FREQ_PROP = CLASS_NAME + ".computeFreqMillis";
    private final boolean publishCount;
    private final boolean publishTotal;
    private final boolean publishMin;
    private final boolean publishMax;
    private final boolean publishMean;
    private final boolean publishVariance;
    private final boolean publishStdDev;
    private final double[] percentiles;
    private final int sampleSize;
    private final long frequencyMillis;

    public StatsConfig(Builder builder) {
        this.publishCount = builder.publishCount;
        this.publishTotal = builder.publishTotal;
        this.publishMin = builder.publishMin;
        this.publishMax = builder.publishMax;
        this.publishMean = builder.publishMean;
        this.publishVariance = builder.publishVariance;
        this.publishStdDev = builder.publishStdDev;
        this.sampleSize = builder.sampleSize;
        this.frequencyMillis = builder.frequencyMillis;
        this.percentiles = Arrays.copyOf(builder.percentiles, builder.percentiles.length);
    }

    public boolean getPublishCount() {
        return this.publishCount;
    }

    public boolean getPublishTotal() {
        return this.publishTotal;
    }

    public boolean getPublishMin() {
        return this.publishMin;
    }

    public boolean getPublishMax() {
        return this.publishMax;
    }

    public boolean getPublishMean() {
        return this.publishMean;
    }

    public boolean getPublishVariance() {
        return this.publishVariance;
    }

    public boolean getPublishStdDev() {
        return this.publishStdDev;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public long getFrequencyMillis() {
        return this.frequencyMillis;
    }

    public double[] getPercentiles() {
        return Arrays.copyOf(this.percentiles, this.percentiles.length);
    }

    public String toString() {
        return "StatsConfig{publishCount=" + this.publishCount + ", publishTotal=" + this.publishTotal + ", publishMin=" + this.publishMin + ", publishMax=" + this.publishMax + ", publishMean=" + this.publishMean + ", publishVariance=" + this.publishVariance + ", publishStdDev=" + this.publishStdDev + ", percentiles=" + Arrays.toString(this.percentiles) + ", sampleSize=" + this.sampleSize + ", frequencyMillis=" + this.frequencyMillis + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatsConfig)) {
            return false;
        }
        StatsConfig that = (StatsConfig)o;
        return this.frequencyMillis == that.frequencyMillis && this.publishCount == that.publishCount && this.publishMax == that.publishMax && this.publishMean == that.publishMean && this.publishMin == that.publishMin && this.publishStdDev == that.publishStdDev && this.publishTotal == that.publishTotal && this.publishVariance == that.publishVariance && this.sampleSize == that.sampleSize && Arrays.equals(this.percentiles, that.percentiles);
    }

    public int hashCode() {
        int result = this.publishCount ? 1 : 0;
        result = 31 * result + (this.publishTotal ? 1 : 0);
        result = 31 * result + (this.publishMin ? 1 : 0);
        result = 31 * result + (this.publishMax ? 1 : 0);
        result = 31 * result + (this.publishMean ? 1 : 0);
        result = 31 * result + (this.publishVariance ? 1 : 0);
        result = 31 * result + (this.publishStdDev ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.percentiles);
        result = 31 * result + this.sampleSize;
        result = 31 * result + (int)(this.frequencyMillis ^ this.frequencyMillis >>> 32);
        return result;
    }

    static /* synthetic */ String access$000() {
        return SIZE_PROP;
    }

    static /* synthetic */ String access$100() {
        return FREQ_PROP;
    }

    public static class Builder {
        private boolean publishCount = true;
        private boolean publishTotal = true;
        private boolean publishMin = false;
        private boolean publishMax = false;
        private boolean publishMean = false;
        private boolean publishVariance = false;
        private boolean publishStdDev = false;
        private int sampleSize = Integer.parseInt(System.getProperty(StatsConfig.access$000(), "1000"));
        private long frequencyMillis = Long.parseLong(System.getProperty(StatsConfig.access$100(), "60000"));
        private double[] percentiles = new double[]{95.0, 99.0};

        public Builder withPublishCount(boolean publishCount) {
            this.publishCount = publishCount;
            return this;
        }

        public Builder withPublishTotal(boolean publishTotal) {
            this.publishTotal = publishTotal;
            return this;
        }

        public Builder withPublishMin(boolean publishMin) {
            this.publishMin = publishMin;
            return this;
        }

        public Builder withPublishMax(boolean publishMax) {
            this.publishMax = publishMax;
            return this;
        }

        public Builder withPublishMean(boolean publishMean) {
            this.publishMean = publishMean;
            return this;
        }

        public Builder withPublishVariance(boolean publishVariance) {
            this.publishVariance = publishVariance;
            return this;
        }

        public Builder withPublishStdDev(boolean publishStdDev) {
            this.publishStdDev = publishStdDev;
            return this;
        }

        public Builder withPercentiles(double[] percentiles) {
            this.percentiles = Arrays.copyOf(percentiles, percentiles.length);
            return this;
        }

        public Builder withSampleSize(int size) {
            this.sampleSize = size;
            return this;
        }

        public Builder withComputeFrequencyMillis(long frequencyMillis) {
            this.frequencyMillis = frequencyMillis;
            return this;
        }

        public StatsConfig build() {
            return new StatsConfig(this);
        }
    }
}

