/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.tag;

import com.spotify.ffwd.http.google.common.collect.Interner;
import com.spotify.ffwd.http.google.common.collect.Interners;
import com.spotify.ffwd.http.netflix.servo.tag.BasicTag;
import com.spotify.ffwd.http.netflix.servo.tag.Tag;

public final class Tags {
    private static final Interner<String> STR_CACHE = Interners.newWeakInterner();
    private static final Interner<Tag> TAG_CACHE = Interners.newWeakInterner();

    public static String intern(String v) {
        return STR_CACHE.intern(v);
    }

    public static Tag intern(Tag t) {
        return TAG_CACHE.intern(t);
    }

    static Tag internCustom(Tag t) {
        return t instanceof BasicTag ? t : Tags.newTag(t.getKey(), t.getValue());
    }

    public static Tag newTag(String key, String value) {
        BasicTag newTag = new BasicTag(Tags.intern(key), Tags.intern(value));
        return Tags.intern(newTag);
    }

    public static Tag parseTag(String tagString) {
        int eqIndex = tagString.indexOf("=");
        if (eqIndex < 0) {
            throw new IllegalArgumentException("key and value must be separated by '='");
        }
        String k = tagString.substring(0, eqIndex).trim();
        String v = tagString.substring(eqIndex + 1, tagString.length()).trim();
        return Tags.newTag(k, v);
    }

    private Tags() {
    }
}

