/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactories {
    private static ThreadFactory backingFactory = Executors.defaultThreadFactory();

    private ThreadFactories() {
    }

    public static ThreadFactory withName(final String fmt) {
        return new ThreadFactory(){
            private AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = backingFactory.newThread(r);
                t.setDaemon(true);
                t.setName(String.format(fmt, this.count.getAndIncrement()));
                return t;
            }
        };
    }
}

