/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.util;

import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class TimeLimiter {
    private final ExecutorService executor;

    public TimeLimiter(ExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    public <T> T callWithTimeout(Callable<T> callable, long duration, TimeUnit unit) throws Exception {
        Future<T> future = this.executor.submit(callable);
        try {
            return future.get(duration, unit);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new UncheckedTimeoutException(e);
        }
    }

    public static class UncheckedTimeoutException
    extends RuntimeException {
        public UncheckedTimeoutException(Exception cause) {
            super(cause);
        }
    }
}

