/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.stats.distribution;

import com.spotify.ffwd.http.netflix.stats.distribution.DataBuffer;
import com.spotify.ffwd.http.netflix.stats.distribution.DataCollector;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.locks.Lock;

public abstract class DataAccumulator
implements DataCollector {
    private DataBuffer current;
    private DataBuffer previous;
    private final Object swapLock = new Object();

    public DataAccumulator(int bufferSize) {
        this.current = new DataBuffer(bufferSize);
        this.previous = new DataBuffer(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void noteValue(double val) {
        Object object = this.swapLock;
        synchronized (object) {
            Lock l = this.current.getLock();
            l.lock();
            try {
                this.current.noteValue(val);
            }
            finally {
                l.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void publish() {
        DataBuffer tmp = null;
        Lock l = null;
        Object object = this.swapLock;
        synchronized (object) {
            tmp = this.current;
            this.current = this.previous;
            this.previous = tmp;
            l = this.current.getLock();
            l.lock();
            try {
                this.current.startCollection();
            }
            finally {
                l.unlock();
            }
            l = tmp.getLock();
            l.lock();
        }
        try {
            tmp.endCollection();
            this.publish(tmp);
        }
        finally {
            l.unlock();
        }
    }

    protected abstract void publish(DataBuffer var1);
}

