/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.stats.distribution;

import com.spotify.ffwd.http.netflix.stats.distribution.Distribution;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DataBuffer
extends Distribution {
    private final Lock lock = new ReentrantLock();
    private final double[] buf;
    private long startMillis;
    private long endMillis;
    private int size;
    private int insertPos;

    public DataBuffer(int capacity) {
        this.buf = new double[capacity];
        this.startMillis = 0L;
        this.size = 0;
        this.insertPos = 0;
    }

    public Lock getLock() {
        return this.lock;
    }

    public int getCapacity() {
        return this.buf.length;
    }

    public long getSampleIntervalMillis() {
        return this.endMillis - this.startMillis;
    }

    public int getSampleSize() {
        return this.size;
    }

    @Override
    public void clear() {
        super.clear();
        this.startMillis = 0L;
        this.size = 0;
        this.insertPos = 0;
    }

    public void startCollection() {
        this.clear();
        this.startMillis = System.currentTimeMillis();
    }

    public void endCollection() {
        this.endMillis = System.currentTimeMillis();
        Arrays.sort(this.buf, 0, this.size);
    }

    @Override
    public void noteValue(double val) {
        super.noteValue(val);
        this.buf[this.insertPos++] = val;
        if (this.insertPos >= this.buf.length) {
            this.insertPos = 0;
            this.size = this.buf.length;
        } else if (this.insertPos > this.size) {
            this.size = this.insertPos;
        }
    }

    public double[] getPercentiles(double[] percents, double[] percentiles) {
        for (int i = 0; i < percents.length; ++i) {
            percentiles[i] = this.computePercentile(percents[i]);
        }
        return percentiles;
    }

    private double computePercentile(double percent) {
        if (this.size <= 0) {
            return 0.0;
        }
        if (percent <= 0.0) {
            return this.buf[0];
        }
        if (percent >= 100.0) {
            return this.buf[this.size - 1];
        }
        double index = percent / 100.0 * (double)this.size;
        int iLow = (int)Math.floor(index);
        int iHigh = (int)Math.ceil(index);
        assert (0 <= iLow && (double)iLow <= index && index <= (double)iHigh && iHigh <= this.size);
        assert (iHigh - iLow <= 1);
        if (iHigh >= this.size) {
            return this.buf[this.size - 1];
        }
        if (iLow == iHigh) {
            return this.buf[iLow];
        }
        return this.buf[iLow] + (index - (double)iLow) * (this.buf[iHigh] - this.buf[iLow]);
    }
}

