/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.stats.distribution;

import com.spotify.ffwd.http.netflix.stats.distribution.DataCollector;
import com.spotify.ffwd.http.netflix.stats.distribution.DistributionMBean;

public class Distribution
implements DistributionMBean,
DataCollector {
    private long numValues = 0L;
    private double sumValues = 0.0;
    private double sumSquareValues = 0.0;
    private double minValue = 0.0;
    private double maxValue = 0.0;

    @Override
    public void noteValue(double val) {
        ++this.numValues;
        this.sumValues += val;
        this.sumSquareValues += val * val;
        if (this.numValues == 1L) {
            this.minValue = val;
            this.maxValue = val;
        } else if (val < this.minValue) {
            this.minValue = val;
        } else if (val > this.maxValue) {
            this.maxValue = val;
        }
    }

    @Override
    public void clear() {
        this.numValues = 0L;
        this.sumValues = 0.0;
        this.sumSquareValues = 0.0;
        this.minValue = 0.0;
        this.maxValue = 0.0;
    }

    @Override
    public long getNumValues() {
        return this.numValues;
    }

    @Override
    public double getMean() {
        if (this.numValues < 1L) {
            return 0.0;
        }
        return this.sumValues / (double)this.numValues;
    }

    @Override
    public double getVariance() {
        if (this.numValues < 2L) {
            return 0.0;
        }
        if (this.sumValues == 0.0) {
            return 0.0;
        }
        double mean = this.getMean();
        return this.sumSquareValues / (double)this.numValues - mean * mean;
    }

    @Override
    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getMinimum() {
        return this.minValue;
    }

    @Override
    public double getMaximum() {
        return this.maxValue;
    }

    public void add(Distribution anotherDistribution) {
        if (anotherDistribution != null) {
            this.numValues += anotherDistribution.numValues;
            this.sumValues += anotherDistribution.sumValues;
            this.sumSquareValues += anotherDistribution.sumSquareValues;
            this.minValue = this.minValue < anotherDistribution.minValue ? this.minValue : anotherDistribution.minValue;
            this.maxValue = this.maxValue > anotherDistribution.maxValue ? this.maxValue : anotherDistribution.maxValue;
        }
    }

    public String toString() {
        return "{Distribution:" + "N=" + this.getNumValues() + ": " + this.getMinimum() + ".." + this.getMean() + ".." + this.getMaximum() + "}";
    }
}

