/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.stats.distribution;

import com.spotify.ffwd.http.netflix.stats.distribution.Distribution;
import com.spotify.ffwd.http.netflix.stats.distribution.HistogramMBean;
import java.util.concurrent.atomic.AtomicLong;

public class Histogram
extends Distribution
implements HistogramMBean {
    private final double[] bucketLimits;
    private final AtomicLong[] bucketCounts;

    public Histogram(double[] bucketLimits) {
        this.bucketLimits = new double[bucketLimits.length];
        for (int i = 0; i < bucketLimits.length; ++i) {
            this.bucketLimits[i] = bucketLimits[i];
        }
        this.bucketCounts = this.makeBuckets(bucketLimits.length + 1);
    }

    public Histogram(double min, double max, double step) {
        this.bucketLimits = new double[1 + (int)Math.ceil((max - min) / step)];
        this.bucketLimits[0] = min;
        for (int i = 1; i < this.bucketLimits.length; ++i) {
            this.bucketLimits[i] = this.bucketLimits[i - 1] + step;
        }
        this.bucketCounts = this.makeBuckets(this.bucketLimits.length + 1);
    }

    private AtomicLong[] makeBuckets(int cnt) {
        AtomicLong[] buckets = new AtomicLong[cnt];
        for (int i = 0; i < cnt; ++i) {
            buckets[i] = new AtomicLong(0L);
        }
        return buckets;
    }

    @Override
    public void noteValue(double val) {
        super.noteValue(val);
        this.updateBucket(val, this.findBucket(val));
    }

    private int findBucket(double val) {
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            if (!(val < this.getBucketMaximum(i))) continue;
            return i;
        }
        return this.getNumBuckets() - 1;
    }

    private void updateBucket(double val, int idx) {
        this.bucketCounts[idx].incrementAndGet();
    }

    private void clearBucket(int idx) {
        this.bucketCounts[idx].set(0L);
    }

    @Override
    public void clear() {
        super.clear();
        for (int idx = 0; idx < this.getNumBuckets(); ++idx) {
            this.clearBucket(idx);
        }
    }

    @Override
    public int getNumBuckets() {
        return this.bucketCounts.length;
    }

    public long getBucketCount(int i) {
        return this.bucketCounts[i].get();
    }

    public double getBucketMinimum(int i) {
        if (i > 0) {
            return this.bucketLimits[i - 1];
        }
        if (this.getBucketCount(i) == 0L) {
            return Double.MIN_VALUE;
        }
        return this.getMinimum();
    }

    public double getBucketMaximum(int i) {
        if (i < this.bucketLimits.length) {
            return this.bucketLimits[i];
        }
        if (this.getBucketCount(i) == 0L) {
            return Double.MAX_VALUE;
        }
        return this.getMaximum();
    }

    @Override
    public long[] getBucketCounts() {
        long[] counts = new long[this.getNumBuckets()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.getBucketCount(i);
        }
        return counts;
    }

    @Override
    public double[] getBucketMinimums() {
        double[] mins = new double[this.getNumBuckets()];
        for (int i = 0; i < mins.length; ++i) {
            mins[i] = this.getBucketMinimum(i);
        }
        return mins;
    }

    @Override
    public double[] getBucketMaximums() {
        double[] maxs = new double[this.getNumBuckets()];
        for (int i = 0; i < maxs.length; ++i) {
            maxs[i] = this.getBucketMaximum(i);
        }
        return maxs;
    }

    @Override
    public double getMedian() {
        return this.getPercentile(50);
    }

    private double getNthValue(double n) {
        double needed;
        if (n <= 0.0) {
            return this.getMinimum();
        }
        if (n >= (double)(this.getNumValues() - 1L)) {
            return this.getMaximum();
        }
        int bucket = 0;
        int lastBucket = this.getNumBuckets() - 1;
        for (needed = n; needed > 0.0 && bucket < lastBucket && needed >= (double)this.getBucketCount(bucket); needed -= (double)this.getBucketCount(bucket), ++bucket) {
        }
        assert (needed >= 0.0);
        double min = this.getBucketMinimum(bucket);
        double max = this.getBucketMaximum(bucket);
        double tmp = this.getMinimum();
        if (min < tmp) {
            min = tmp;
        }
        if (max > (tmp = this.getMaximum())) {
            max = tmp;
        }
        assert (min <= max);
        long count = this.getBucketCount(bucket);
        assert (needed <= (double)count);
        double value = bucket < lastBucket ? min + (max - min) * needed / (double)count : (count == 1L ? max : min + (max - min) * needed / (double)(count - 1L));
        return value;
    }

    @Override
    public double getPercentile(int percent) {
        if (this.getNumValues() == 0L) {
            return this.getMinimum();
        }
        return this.getNthValue((double)this.getNumValues() * ((double)percent / 100.0));
    }

    private double getValueIndex(double value) {
        int bucket;
        if (value <= this.getMinimum()) {
            return 0.0;
        }
        if (value >= this.getMaximum()) {
            return this.getNumValues() - 1L;
        }
        int lastBucket = this.getNumBuckets() - 1;
        double idx = 0.0;
        for (bucket = 0; bucket < lastBucket && this.getBucketMaximum(bucket) <= value; ++bucket) {
            idx += (double)this.getBucketCount(bucket);
        }
        double min = this.getBucketMinimum(bucket);
        double max = this.getBucketMaximum(bucket);
        long count = this.getBucketCount(bucket);
        assert (min <= value);
        assert (value < max);
        if (count == 0L) {
            count = 0L;
        } else {
            idx = bucket < lastBucket ? (idx += (double)count * (value - min) / (max - min)) : (idx += (double)(count - 1L) * (value - min) / (max - min));
        }
        assert (idx >= 0.0);
        assert (idx <= (double)(this.getNumValues() - 1L));
        return idx;
    }

    @Override
    public long getPercentileRank(double value) {
        if (this.getNumValues() <= 1L) {
            return 50L;
        }
        return Math.round(this.getValueIndex(value) * 100.0 / (double)(this.getNumValues() - 1L));
    }
}

