/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.xbill.DNS;

import com.spotify.ffwd.http.xbill.DNS.CNAMERecord;
import com.spotify.ffwd.http.xbill.DNS.DNAMERecord;
import com.spotify.ffwd.http.xbill.DNS.Master;
import com.spotify.ffwd.http.xbill.DNS.Message;
import com.spotify.ffwd.http.xbill.DNS.Name;
import com.spotify.ffwd.http.xbill.DNS.NameTooLongException;
import com.spotify.ffwd.http.xbill.DNS.Options;
import com.spotify.ffwd.http.xbill.DNS.RRset;
import com.spotify.ffwd.http.xbill.DNS.Record;
import com.spotify.ffwd.http.xbill.DNS.SOARecord;
import com.spotify.ffwd.http.xbill.DNS.SetResponse;
import com.spotify.ffwd.http.xbill.DNS.Type;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cache {
    private CacheMap data;
    private int maxncache = -1;
    private int maxcache = -1;
    private int dclass;
    private static final int defaultMaxEntries = 50000;

    private static int limitExpire(long ttl, long maxttl) {
        long expire;
        if (maxttl >= 0L && maxttl < ttl) {
            ttl = maxttl;
        }
        if ((expire = System.currentTimeMillis() / 1000L + ttl) < 0L || expire > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)expire;
    }

    public Cache(int dclass) {
        this.dclass = dclass;
        this.data = new CacheMap(50000);
    }

    public Cache() {
        this(1);
    }

    public Cache(String file) throws IOException {
        Record record;
        this.data = new CacheMap(50000);
        Master m = new Master(file);
        while ((record = m.nextRecord()) != null) {
            this.addRecord(record, 0, m);
        }
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized void removeName(Name name) {
        this.data.remove(name);
    }

    private synchronized Element[] allElements(Object types) {
        if (types instanceof List) {
            List typelist = (List)types;
            int size = typelist.size();
            return typelist.toArray(new Element[size]);
        }
        Element set = (Element)types;
        return new Element[]{set};
    }

    private synchronized Element oneElement(Name name, Object types, int type, int minCred) {
        Element found = null;
        if (type == 255) {
            throw new IllegalArgumentException("oneElement(ANY)");
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                Element set = (Element)list.get(i);
                if (set.getType() != type) continue;
                found = set;
                break;
            }
        } else {
            Element set = (Element)types;
            if (set.getType() == type) {
                found = set;
            }
        }
        if (found == null) {
            return null;
        }
        if (found.expired()) {
            this.removeElement(name, type);
            return null;
        }
        if (found.compareCredibility(minCred) < 0) {
            return null;
        }
        return found;
    }

    private synchronized Element findElement(Name name, int type, int minCred) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneElement(name, types, type, minCred);
    }

    private synchronized void addElement(Name name, Element element) {
        Object types = this.data.get(name);
        if (types == null) {
            this.data.put(name, element);
            return;
        }
        int type = element.getType();
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                Element elt = (Element)list.get(i);
                if (elt.getType() != type) continue;
                list.set(i, element);
                return;
            }
            list.add(element);
        } else {
            Element elt = (Element)types;
            if (elt.getType() == type) {
                this.data.put(name, element);
            } else {
                LinkedList<Element> list = new LinkedList<Element>();
                list.add(elt);
                list.add(element);
                this.data.put(name, list);
            }
        }
    }

    private synchronized void removeElement(Name name, int type) {
        Object types = this.data.get(name);
        if (types == null) {
            return;
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                Element elt = (Element)list.get(i);
                if (elt.getType() != type) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            Element elt = (Element)types;
            if (elt.getType() != type) {
                return;
            }
            this.data.remove(name);
        }
    }

    public synchronized void clearCache() {
        this.data.clear();
    }

    public synchronized void addRecord(Record r, int cred, Object o) {
        Name name = r.getName();
        int type = r.getRRsetType();
        if (!Type.isRR(type)) {
            return;
        }
        Element element = this.findElement(name, type, cred);
        if (element == null) {
            CacheRRset crrset = new CacheRRset(r, cred, (long)this.maxcache);
            this.addRRset(crrset, cred);
        } else if (element.compareCredibility(cred) == 0 && element instanceof CacheRRset) {
            CacheRRset crrset = (CacheRRset)element;
            crrset.addRR(r);
        }
    }

    public synchronized void addRRset(RRset rrset, int cred) {
        long ttl = rrset.getTTL();
        Name name = rrset.getName();
        int type = rrset.getType();
        Element element = this.findElement(name, type, 0);
        if (ttl == 0L) {
            if (element != null && element.compareCredibility(cred) <= 0) {
                this.removeElement(name, type);
            }
        } else {
            if (element != null && element.compareCredibility(cred) <= 0) {
                element = null;
            }
            if (element == null) {
                CacheRRset crrset = rrset instanceof CacheRRset ? (CacheRRset)rrset : new CacheRRset(rrset, cred, (long)this.maxcache);
                this.addElement(name, crrset);
            }
        }
    }

    public synchronized void addNegative(Name name, int type, SOARecord soa, int cred) {
        long ttl = 0L;
        if (soa != null) {
            ttl = soa.getTTL();
        }
        Element element = this.findElement(name, type, 0);
        if (ttl == 0L) {
            if (element != null && element.compareCredibility(cred) <= 0) {
                this.removeElement(name, type);
            }
        } else {
            if (element != null && element.compareCredibility(cred) <= 0) {
                element = null;
            }
            if (element == null) {
                this.addElement(name, new NegativeElement(name, type, soa, cred, this.maxncache));
            }
        }
    }

    protected synchronized SetResponse lookup(Name name, int type, int minCred) {
        int labels;
        for (int tlabels = labels = name.labels(); tlabels >= 1; --tlabels) {
            Element element;
            SetResponse sr;
            boolean isExact;
            boolean isRoot = tlabels == 1;
            boolean bl = isExact = tlabels == labels;
            Name tname = isRoot ? Name.root : (isExact ? name : new Name(name, labels - tlabels));
            Object types = this.data.get(tname);
            if (types == null) continue;
            if (isExact && type == 255) {
                sr = new SetResponse(6);
                Element[] elements = this.allElements(types);
                int added = 0;
                for (int i = 0; i < elements.length; ++i) {
                    element = elements[i];
                    if (element.expired()) {
                        this.removeElement(tname, element.getType());
                        continue;
                    }
                    if (!(element instanceof CacheRRset) || element.compareCredibility(minCred) < 0) continue;
                    sr.addRRset((CacheRRset)element);
                    ++added;
                }
                if (added > 0) {
                    return sr;
                }
            } else if (isExact) {
                element = this.oneElement(tname, types, type, minCred);
                if (element != null && element instanceof CacheRRset) {
                    sr = new SetResponse(6);
                    sr.addRRset((CacheRRset)element);
                    return sr;
                }
                if (element != null) {
                    sr = new SetResponse(2);
                    return sr;
                }
                element = this.oneElement(tname, types, 5, minCred);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(4, (CacheRRset)element);
                }
            } else {
                element = this.oneElement(tname, types, 39, minCred);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(5, (CacheRRset)element);
                }
            }
            if ((element = this.oneElement(tname, types, 2, minCred)) != null && element instanceof CacheRRset) {
                return new SetResponse(3, (CacheRRset)element);
            }
            if (!isExact || (element = this.oneElement(tname, types, 0, minCred)) == null) continue;
            return SetResponse.ofType(1);
        }
        return SetResponse.ofType(0);
    }

    public SetResponse lookupRecords(Name name, int type, int minCred) {
        return this.lookup(name, type, minCred);
    }

    private RRset[] findRecords(Name name, int type, int minCred) {
        SetResponse cr = this.lookupRecords(name, type, minCred);
        if (cr.isSuccessful()) {
            return cr.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, int type) {
        return this.findRecords(name, type, 3);
    }

    public RRset[] findAnyRecords(Name name, int type) {
        return this.findRecords(name, type, 2);
    }

    private final int getCred(int section, boolean isAuth) {
        if (section == 1) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 2) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rrset, Set names) {
        Record first = rrset.first();
        if (first.getAdditionalName() == null) {
            return;
        }
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            Name name = r.getAdditionalName();
            if (name == null) continue;
            names.add(name);
        }
    }

    public SetResponse addMessage(Message in) {
        int i;
        int cred;
        boolean isAuth = in.getHeader().getFlag(5);
        Record question = in.getQuestion();
        int rcode = in.getHeader().getRcode();
        boolean completed = false;
        SetResponse response = null;
        boolean verbose = Options.check("verbosecache");
        if (rcode != 0 && rcode != 3 || question == null) {
            return null;
        }
        Name qname = question.getName();
        int qtype = question.getType();
        int qclass = question.getDClass();
        Name curname = qname;
        HashSet additionalNames = new HashSet();
        RRset[] answers = in.getSectionRRsets(1);
        for (int i2 = 0; i2 < answers.length; ++i2) {
            if (answers[i2].getDClass() != qclass) continue;
            int type = answers[i2].getType();
            Name name = answers[i2].getName();
            cred = this.getCred(1, isAuth);
            if ((type == qtype || qtype == 255) && name.equals(curname)) {
                this.addRRset(answers[i2], cred);
                completed = true;
                if (curname == qname) {
                    if (response == null) {
                        response = new SetResponse(6);
                    }
                    response.addRRset(answers[i2]);
                }
                Cache.markAdditional(answers[i2], additionalNames);
                continue;
            }
            if (type == 5 && name.equals(curname)) {
                this.addRRset(answers[i2], cred);
                if (curname == qname) {
                    response = new SetResponse(4, answers[i2]);
                }
                CNAMERecord cname = (CNAMERecord)answers[i2].first();
                curname = cname.getTarget();
                continue;
            }
            if (type != 39 || !curname.subdomain(name)) continue;
            this.addRRset(answers[i2], cred);
            if (curname == qname) {
                response = new SetResponse(5, answers[i2]);
            }
            DNAMERecord dname = (DNAMERecord)answers[i2].first();
            try {
                curname = curname.fromDNAME(dname);
                continue;
            }
            catch (NameTooLongException e) {
                break;
            }
        }
        RRset[] auth = in.getSectionRRsets(2);
        RRset soa = null;
        RRset ns = null;
        for (i = 0; i < auth.length; ++i) {
            if (auth[i].getType() == 6 && curname.subdomain(auth[i].getName())) {
                soa = auth[i];
                continue;
            }
            if (auth[i].getType() != 2 || !curname.subdomain(auth[i].getName())) continue;
            ns = auth[i];
        }
        if (!completed) {
            int cachetype;
            int n = cachetype = rcode == 3 ? 0 : qtype;
            if (rcode == 3 || soa != null || ns == null) {
                cred = this.getCred(2, isAuth);
                SOARecord soarec = null;
                if (soa != null) {
                    soarec = (SOARecord)soa.first();
                }
                this.addNegative(curname, cachetype, soarec, cred);
                if (response == null) {
                    int responseType = rcode == 3 ? 1 : 2;
                    response = SetResponse.ofType(responseType);
                }
            } else {
                cred = this.getCred(2, isAuth);
                this.addRRset(ns, cred);
                Cache.markAdditional(ns, additionalNames);
                if (response == null) {
                    response = new SetResponse(3, ns);
                }
            }
        } else if (rcode == 0 && ns != null) {
            cred = this.getCred(2, isAuth);
            this.addRRset(ns, cred);
            Cache.markAdditional(ns, additionalNames);
        }
        RRset[] addl = in.getSectionRRsets(3);
        for (i = 0; i < addl.length; ++i) {
            Name name;
            int type = addl[i].getType();
            if (type != 1 && type != 28 && type != 38 || !additionalNames.contains(name = addl[i].getName())) continue;
            cred = this.getCred(3, isAuth);
            this.addRRset(addl[i], cred);
        }
        if (verbose) {
            System.out.println("addMessage: " + response);
        }
        return response;
    }

    public void flushSet(Name name, int type) {
        this.removeElement(name, type);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setMaxNCache(int seconds) {
        this.maxncache = seconds;
    }

    public int getMaxNCache() {
        return this.maxncache;
    }

    public void setMaxCache(int seconds) {
        this.maxcache = seconds;
    }

    public int getMaxCache() {
        return this.maxcache;
    }

    public int getSize() {
        return this.data.size();
    }

    public int getMaxEntries() {
        return this.data.getMaxSize();
    }

    public void setMaxEntries(int entries) {
        this.data.setMaxSize(entries);
    }

    public int getDClass() {
        return this.dclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Cache cache = this;
        synchronized (cache) {
            Iterator it = this.data.values().iterator();
            while (it.hasNext()) {
                Element[] elements = this.allElements(it.next());
                for (int i = 0; i < elements.length; ++i) {
                    sb.append(elements[i]);
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static class CacheMap
    extends LinkedHashMap {
        private int maxsize = -1;

        CacheMap(int maxsize) {
            super(16, 0.75f, true);
            this.maxsize = maxsize;
        }

        int getMaxSize() {
            return this.maxsize;
        }

        void setMaxSize(int maxsize) {
            this.maxsize = maxsize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.maxsize >= 0 && this.size() > this.maxsize;
        }
    }

    private static class NegativeElement
    implements Element {
        int type;
        Name name;
        int credibility;
        int expire;

        public NegativeElement(Name name, int type, SOARecord soa, int cred, long maxttl) {
            this.name = name;
            this.type = type;
            long cttl = 0L;
            if (soa != null) {
                cttl = soa.getMinimum();
            }
            this.credibility = cred;
            this.expire = Cache.limitExpire(cttl, maxttl);
        }

        public int getType() {
            return this.type;
        }

        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        public final int compareCredibility(int cred) {
            return this.credibility - cred;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.type == 0) {
                sb.append("NXDOMAIN " + this.name);
            } else {
                sb.append("NXRRSET " + this.name + " " + Type.string(this.type));
            }
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static class CacheRRset
    extends RRset
    implements Element {
        private static final long serialVersionUID = 5971755205903597024L;
        int credibility;
        int expire;

        public CacheRRset(Record rec, int cred, long maxttl) {
            this.credibility = cred;
            this.expire = Cache.limitExpire(rec.getTTL(), maxttl);
            this.addRR(rec);
        }

        public CacheRRset(RRset rrset, int cred, long maxttl) {
            super(rrset);
            this.credibility = cred;
            this.expire = Cache.limitExpire(rrset.getTTL(), maxttl);
        }

        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        public final int compareCredibility(int cred) {
            return this.credibility - cred;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static interface Element {
        public boolean expired();

        public int compareCredibility(int var1);

        public int getType();
    }
}

