/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.xbill.DNS;

import com.spotify.ffwd.http.xbill.DNS.TextParseException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

final class FormattedTime {
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w4;

    private FormattedTime() {
    }

    public static String format(Date date) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        StringBuffer sb = new StringBuffer();
        c.setTime(date);
        sb.append(w4.format(c.get(1)));
        sb.append(w2.format(c.get(2) + 1));
        sb.append(w2.format(c.get(5)));
        sb.append(w2.format(c.get(11)));
        sb.append(w2.format(c.get(12)));
        sb.append(w2.format(c.get(13)));
        return sb.toString();
    }

    public static Date parse(String s) throws TextParseException {
        if (s.length() != 14) {
            throw new TextParseException("Invalid time encoding: " + s);
        }
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        c.clear();
        try {
            int year = Integer.parseInt(s.substring(0, 4));
            int month = Integer.parseInt(s.substring(4, 6)) - 1;
            int date = Integer.parseInt(s.substring(6, 8));
            int hour = Integer.parseInt(s.substring(8, 10));
            int minute = Integer.parseInt(s.substring(10, 12));
            int second = Integer.parseInt(s.substring(12, 14));
            c.set(year, month, date, hour, minute, second);
        }
        catch (NumberFormatException e) {
            throw new TextParseException("Invalid time encoding: " + s);
        }
        return c.getTime();
    }

    static {
        w2.setMinimumIntegerDigits(2);
        w4 = new DecimalFormat();
        w4.setMinimumIntegerDigits(4);
        w4.setGroupingUsed(false);
    }
}

