/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.xbill.DNS;

import com.spotify.ffwd.http.xbill.DNS.Compression;
import com.spotify.ffwd.http.xbill.DNS.DNSInput;
import com.spotify.ffwd.http.xbill.DNS.DNSOutput;
import com.spotify.ffwd.http.xbill.DNS.Name;
import com.spotify.ffwd.http.xbill.DNS.Options;
import com.spotify.ffwd.http.xbill.DNS.Record;
import com.spotify.ffwd.http.xbill.DNS.Tokenizer;
import com.spotify.ffwd.http.xbill.DNS.utils.base64;
import java.io.IOException;

public class OPENPGPKEYRecord
extends Record {
    private static final long serialVersionUID = -1277262990243423062L;
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    Record getObject() {
        return new OPENPGPKEYRecord();
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.cert = in.readByteArray();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }
}

