/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.xbill.DNS;

import com.spotify.ffwd.http.xbill.DNS.DNSOutput;
import com.spotify.ffwd.http.xbill.DNS.Message;
import com.spotify.ffwd.http.xbill.DNS.Name;
import com.spotify.ffwd.http.xbill.DNS.Options;
import com.spotify.ffwd.http.xbill.DNS.TSIGRecord;
import com.spotify.ffwd.http.xbill.DNS.TextParseException;
import com.spotify.ffwd.http.xbill.DNS.utils.base64;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class TSIG {
    public static final Name HMAC_MD5;
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    private static Map algMap;
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private Mac hmac;

    public static Name algorithmToName(String alg) {
        Iterator it = algMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!alg.equalsIgnoreCase((String)entry.getValue())) continue;
            return (Name)entry.getKey();
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    public static String nameToAlgorithm(Name name) {
        String alg = (String)algMap.get(name);
        if (alg != null) {
            return alg;
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    private static boolean verify(Mac mac, byte[] signature) {
        return TSIG.verify(mac, signature, false);
    }

    private static boolean verify(Mac mac, byte[] signature, boolean truncation_ok) {
        byte[] expected = mac.doFinal();
        if (truncation_ok && signature.length < expected.length) {
            byte[] truncated = new byte[signature.length];
            System.arraycopy(expected, 0, truncated, 0, truncated.length);
            expected = truncated;
        }
        return Arrays.equals(signature, expected);
    }

    private void init_hmac(String macAlgorithm, SecretKey key) {
        try {
            this.hmac = Mac.getInstance(macAlgorithm);
            this.hmac.init(key);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Caught security exception setting up HMAC.");
        }
    }

    public TSIG(Name algorithm, Name name, byte[] keyBytes) {
        this.name = name;
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        SecretKeySpec key = new SecretKeySpec(keyBytes, macAlgorithm);
        this.init_hmac(macAlgorithm, key);
    }

    public TSIG(Name algorithm, Name name, SecretKey key) {
        this.name = name;
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(algorithm);
        this.init_hmac(macAlgorithm, key);
    }

    public TSIG(Mac mac, Name name) {
        this.name = name;
        this.hmac = mac;
        this.alg = TSIG.algorithmToName(mac.getAlgorithm());
    }

    public TSIG(Name name, byte[] key) {
        this(HMAC_MD5, name, key);
    }

    public TSIG(Name algorithm, String name, String key) {
        byte[] keyBytes = base64.fromString(key);
        if (keyBytes == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(name, Name.root);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = algorithm;
        String macAlgorithm = TSIG.nameToAlgorithm(this.alg);
        this.init_hmac(macAlgorithm, new SecretKeySpec(keyBytes, macAlgorithm));
    }

    public TSIG(String algorithm, String name, String key) {
        this(TSIG.algorithmToName(algorithm), name, key);
    }

    public TSIG(String name, String key) {
        this(HMAC_MD5, name, key);
    }

    public static TSIG fromString(String str) {
        String[] parts = str.split("[:/]", 3);
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid TSIG key specification");
        }
        if (parts.length == 3) {
            try {
                return new TSIG(parts[0], parts[1], parts[2]);
            }
            catch (IllegalArgumentException e) {
                parts = str.split("[:/]", 2);
            }
        }
        return new TSIG(HMAC_MD5, parts[0], parts[1]);
    }

    public TSIGRecord generate(Message m, byte[] b, int error, TSIGRecord old) {
        DNSOutput out;
        int fudge;
        Date timeSigned = error != 18 ? new Date() : old.getTimeSigned();
        boolean signing = false;
        if (error == 0 || error == 18) {
            signing = true;
            this.hmac.reset();
        }
        if ((fudge = Options.intValue("tsigfudge")) < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        if (old != null) {
            out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            if (signing) {
                this.hmac.update(out.toByteArray());
                this.hmac.update(old.getSignature());
            }
        }
        if (signing) {
            this.hmac.update(b);
        }
        out = new DNSOutput();
        this.name.toWireCanonical(out);
        out.writeU16(255);
        out.writeU32(0L);
        this.alg.toWireCanonical(out);
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(fudge);
        out.writeU16(error);
        out.writeU16(0);
        if (signing) {
            this.hmac.update(out.toByteArray());
        }
        byte[] signature = signing ? this.hmac.doFinal() : new byte[]{};
        byte[] other = null;
        if (error == 18) {
            out = new DNSOutput();
            time = new Date().getTime() / 1000L;
            timeHigh = (int)(time >> 32);
            timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            other = out.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m.getHeader().getID(), error, other);
    }

    public void apply(Message m, int error, TSIGRecord old) {
        TSIGRecord r = this.generate(m, m.toWire(), error, old);
        m.addRecord(r, 3);
        m.tsigState = 3;
    }

    public void apply(Message m, TSIGRecord old) {
        this.apply(m, 0, old);
    }

    public void applyStream(Message m, TSIGRecord old, boolean first) {
        if (first) {
            this.apply(m, old);
            return;
        }
        Date timeSigned = new Date();
        this.hmac.reset();
        int fudge = Options.intValue("tsigfudge");
        if (fudge < 0 || fudge > Short.MAX_VALUE) {
            fudge = 300;
        }
        DNSOutput out = new DNSOutput();
        out.writeU16(old.getSignature().length);
        this.hmac.update(out.toByteArray());
        this.hmac.update(old.getSignature());
        this.hmac.update(m.toWire());
        out = new DNSOutput();
        long time = timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(fudge);
        this.hmac.update(out.toByteArray());
        byte[] signature = this.hmac.doFinal();
        byte[] other = null;
        TSIGRecord r = new TSIGRecord(this.name, 255, 0L, this.alg, timeSigned, fudge, signature, m.getHeader().getID(), 0, other);
        m.addRecord(r, 3);
        m.tsigState = 3;
    }

    public byte verify(Message m, byte[] b, int length, TSIGRecord old) {
        m.tsigState = 4;
        TSIGRecord tsig = m.getTSIG();
        this.hmac.reset();
        if (tsig == null) {
            return 1;
        }
        if (!tsig.getName().equals(this.name) || !tsig.getAlgorithm().equals(this.alg)) {
            if (Options.check("verbose")) {
                System.err.println("BADKEY failure");
            }
            return 17;
        }
        long now = System.currentTimeMillis();
        long then = tsig.getTimeSigned().getTime();
        long fudge = tsig.getFudge();
        if (Math.abs(now - then) > fudge * 1000L) {
            if (Options.check("verbose")) {
                System.err.println("BADTIME failure");
            }
            return 18;
        }
        if (old != null && tsig.getError() != 17 && tsig.getError() != 16) {
            DNSOutput out = new DNSOutput();
            out.writeU16(old.getSignature().length);
            this.hmac.update(out.toByteArray());
            this.hmac.update(old.getSignature());
        }
        m.getHeader().decCount(3);
        byte[] header = m.getHeader().toWire();
        m.getHeader().incCount(3);
        this.hmac.update(header);
        int len = m.tsigstart - header.length;
        this.hmac.update(b, header.length, len);
        DNSOutput out = new DNSOutput();
        tsig.getName().toWireCanonical(out);
        out.writeU16(tsig.dclass);
        out.writeU32(tsig.ttl);
        tsig.getAlgorithm().toWireCanonical(out);
        long time = tsig.getTimeSigned().getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(tsig.getFudge());
        out.writeU16(tsig.getError());
        if (tsig.getOther() != null) {
            out.writeU16(tsig.getOther().length);
            out.writeByteArray(tsig.getOther());
        } else {
            out.writeU16(0);
        }
        this.hmac.update(out.toByteArray());
        byte[] signature = tsig.getSignature();
        int digestLength = this.hmac.getMacLength();
        int minDigestLength = this.hmac.getAlgorithm().toLowerCase().contains("md5") ? 10 : digestLength / 2;
        if (signature.length > digestLength) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature too long");
            }
            return 16;
        }
        if (signature.length < minDigestLength) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature too short");
            }
            return 16;
        }
        if (!TSIG.verify(this.hmac, signature, true)) {
            if (Options.check("verbose")) {
                System.err.println("BADSIG: signature verification");
            }
            return 16;
        }
        m.tsigState = 1;
        return 0;
    }

    public int verify(Message m, byte[] b, TSIGRecord old) {
        return this.verify(m, b, b.length, old);
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString("hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString("hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString("hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString("hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString("hmac-sha512.");
        HashMap<Name, String> out = new HashMap<Name, String>();
        out.put(HMAC_MD5, "HmacMD5");
        out.put(HMAC_SHA1, "HmacSHA1");
        out.put(HMAC_SHA224, "HmacSHA224");
        out.put(HMAC_SHA256, "HmacSHA256");
        out.put(HMAC_SHA384, "HmacSHA384");
        out.put(HMAC_SHA512, "HmacSHA512");
        algMap = Collections.unmodifiableMap(out);
    }

    public static class StreamVerifier {
        private TSIG key;
        private Mac verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tsig, TSIGRecord old) {
            this.key = tsig;
            this.verifier = tsig.hmac;
            this.nresponses = 0;
            this.lastTSIG = old;
        }

        public int verify(Message m, byte[] b) {
            TSIGRecord tsig = m.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int result = this.key.verify(m, b, this.lastTSIG);
                if (result == 0) {
                    byte[] signature = tsig.getSignature();
                    DNSOutput out = new DNSOutput();
                    out.writeU16(signature.length);
                    this.verifier.update(out.toByteArray());
                    this.verifier.update(signature);
                }
                this.lastTSIG = tsig;
                return result;
            }
            if (tsig != null) {
                m.getHeader().decCount(3);
            }
            byte[] header = m.getHeader().toWire();
            if (tsig != null) {
                m.getHeader().incCount(3);
            }
            this.verifier.update(header);
            int len = tsig == null ? b.length - header.length : m.tsigstart - header.length;
            this.verifier.update(b, header.length, len);
            if (tsig == null) {
                boolean required;
                boolean bl = required = this.nresponses - this.lastsigned >= 100;
                if (required) {
                    m.tsigState = 4;
                    return 1;
                }
                m.tsigState = 2;
                return 0;
            }
            this.lastsigned = this.nresponses;
            this.lastTSIG = tsig;
            if (!tsig.getName().equals(this.key.name) || !tsig.getAlgorithm().equals(this.key.alg)) {
                if (Options.check("verbose")) {
                    System.err.println("BADKEY failure");
                }
                m.tsigState = 4;
                return 17;
            }
            DNSOutput out = new DNSOutput();
            long time = tsig.getTimeSigned().getTime() / 1000L;
            int timeHigh = (int)(time >> 32);
            long timeLow = time & 0xFFFFFFFFL;
            out.writeU16(timeHigh);
            out.writeU32(timeLow);
            out.writeU16(tsig.getFudge());
            this.verifier.update(out.toByteArray());
            if (!TSIG.verify(this.verifier, tsig.getSignature())) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG failure");
                }
                m.tsigState = 4;
                return 16;
            }
            this.verifier.reset();
            out = new DNSOutput();
            out.writeU16(tsig.getSignature().length);
            this.verifier.update(out.toByteArray());
            this.verifier.update(tsig.getSignature());
            m.tsigState = 1;
            return 0;
        }
    }
}

