/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.freezer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.freezer.ConfigSerializer;
import com.spotify.flo.freezer.Persisted;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.java.PackageRegistrar;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistingContext
extends ForwardingEvalContext {
    private static final Logger LOG = LoggerFactory.getLogger(PersistingContext.class);
    private final Path basePath;
    private final Map<TaskId, Path> files = new LinkedHashMap<TaskId, Path>();

    public PersistingContext(Path basePath, EvalContext delegate) {
        super(delegate);
        this.basePath = Objects.requireNonNull(basePath);
    }

    public Map<TaskId, Path> getFiles() {
        return this.files;
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        task.inputs();
        Path file = this.taskFile(task.id());
        this.files.put(task.id(), file);
        try {
            PersistingContext.serialize(task, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.evaluateInternal(task, context);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<T> processFn) {
        EvalContext.Promise promise = this.promise();
        LOG.info("Will not invoke {}", (Object)taskId);
        promise.fail((Throwable)new Persisted());
        return promise.value();
    }

    public static void serialize(Object object, Path file) throws Exception {
        try {
            PersistingContext.serialize(object, Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void serialize(Object object, OutputStream outputStream) {
        Kryo kryo = PersistingContext.getKryo();
        try (Output output = new Output(outputStream);){
            kryo.writeClassAndObject(output, object);
        }
    }

    public static <T> T deserialize(Path filePath) throws Exception {
        return PersistingContext.deserialize(Files.newInputStream(filePath, new OpenOption[0]));
    }

    public static <T> T deserialize(InputStream inputStream) {
        Kryo kryo = PersistingContext.getKryo();
        try (Input input = new Input(inputStream);){
            Object object = kryo.readClassAndObject(input);
            return (T)object;
        }
    }

    private static Kryo getKryo() {
        Kryo kryo;
        Class<?> scalaKryoInstantiatorClass = null;
        try {
            scalaKryoInstantiatorClass = Class.forName("com.twitter.chill.ScalaKryoInstantiator");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Could not find com.twitter.chill.ScalaKryoInstantiator: {}", (Throwable)e);
        }
        if (scalaKryoInstantiatorClass != null) {
            KryoInstantiator instantiator;
            LOG.debug("using chill-scala");
            try {
                instantiator = (KryoInstantiator)KryoInstantiator.class.cast(scalaKryoInstantiatorClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            kryo = instantiator.newKryo();
        } else {
            LOG.debug("using chill-java");
            kryo = new Kryo();
            PackageRegistrar.all().apply(kryo);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        }
        kryo.register(SerializedLambda.class);
        try {
            kryo.register(Class.forName("com.typesafe.config.impl.SimpleConfig"), (Serializer)new ConfigSerializer());
        }
        catch (ClassNotFoundException e) {
            LOG.debug("ConfigSerializer not registered", (Throwable)e);
        }
        kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
        kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
        return kryo;
    }

    public static String cleanForFilename(TaskId taskId) {
        return taskId.toString().toLowerCase().replaceAll("[,#()]+", "_").replaceAll("[^a-z0-9_]*", "");
    }

    private Path taskFile(TaskId taskId) {
        return this.basePath.resolve(PersistingContext.cleanForFilename(taskId));
    }
}

