/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.freezer;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.Util;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.freezer.PersistingContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EvaluatingContext {
    static final String OUTPUT_SUFFIX = "_out";
    private final Path basePath;
    private final EvalContext delegate;

    public EvaluatingContext(Path basePath, EvalContext delegate) {
        this.basePath = Objects.requireNonNull(basePath);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public <T> EvalContext.Value<T> evaluateTaskFrom(Path persistedTask) {
        Task task = null;
        try {
            task = (Task)PersistingContext.deserialize(persistedTask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SpecificEval(task, this.delegate).evaluate(task);
    }

    private Path resolveExistingOutput(TaskId taskId) {
        String fileName = PersistingContext.cleanForFilename(taskId) + OUTPUT_SUFFIX;
        return this.basePath.resolve(fileName);
    }

    private <T> void persist(TaskId taskId, T output) {
        Path outputPath = this.basePath.resolve(PersistingContext.cleanForFilename(taskId) + OUTPUT_SUFFIX);
        try {
            PersistingContext.serialize(output, outputPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SpecificEval
    extends ForwardingEvalContext {
        private final Task<?> evalTask;

        protected SpecificEval(Task<?> evalTask, EvalContext delegate) {
            super(delegate);
            this.evalTask = evalTask;
        }

        public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
            EvalContext.Promise promise = this.promise();
            TaskId id = task.id();
            Set inputTaskIds = this.evalTask.inputs().stream().map(Task::id).collect(Collectors.toSet());
            if (inputTaskIds.contains(id)) {
                Path inputValuePath = EvaluatingContext.this.resolveExistingOutput(id);
                if (Files.exists(inputValuePath, new LinkOption[0])) {
                    try {
                        Object value = PersistingContext.deserialize(inputValuePath);
                        promise.set(value);
                    }
                    catch (Exception e) {
                        promise.fail((Throwable)e);
                    }
                } else {
                    promise.fail((Throwable)new RuntimeException("Output value for input task " + id + " not found"));
                }
            } else if (!id.equals(this.evalTask.id())) {
                promise.fail((Throwable)new RuntimeException("Evaluation of unexpected task: " + id));
            } else {
                EvalContext.Value tValue = super.evaluateInternal(task, context);
                tValue.consume(v -> EvaluatingContext.this.persist(this.evalTask.id(), v));
                tValue.consume(arg_0 -> ((EvalContext.Promise)promise).set(arg_0));
                tValue.onFail(arg_0 -> ((EvalContext.Promise)promise).fail(arg_0));
            }
            return promise.value();
        }

        public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<EvalContext.Value<T>> processFn) {
            EvalContext.Value tValue = super.invokeProcessFn(taskId, processFn);
            tValue.consume(v -> LOG.info("{} == {}", (Object)Util.colored((TaskId)taskId), v));
            return tValue;
        }
    }
}

