/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.freezer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.Util;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.freezer.Persisted;
import java.io.IOException;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistingContext
extends ForwardingEvalContext {
    private static final Logger LOG = LoggerFactory.getLogger(PersistingContext.class);
    private final Path basePath;
    private final Map<TaskId, Path> files = new LinkedHashMap<TaskId, Path>();

    public PersistingContext(Path basePath, EvalContext delegate) {
        super(delegate);
        this.basePath = Objects.requireNonNull(basePath);
    }

    public Map<TaskId, Path> getFiles() {
        return this.files;
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        task.inputs();
        Path file = this.taskFile(task.id());
        this.files.put(task.id(), file);
        try {
            PersistingContext.serialize(task, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.evaluateInternal(task, context);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<EvalContext.Value<T>> processFn) {
        EvalContext.Promise promise = this.promise();
        LOG.info("Will not invoke {}", (Object)Util.colored((TaskId)taskId));
        promise.fail((Throwable)new Persisted());
        return promise.value();
    }

    public static void serialize(Object object, Path file) throws Exception {
        Kryo kryo = new Kryo();
        kryo.register(SerializedLambda.class);
        kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
        if (Files.exists(file, new LinkOption[0])) {
            throw new RuntimeException("File " + file + " already exists");
        }
        try (Output output = new Output(Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            kryo.writeClassAndObject(output, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(Path filePath) throws Exception {
        Kryo kryo = new Kryo();
        kryo.register(SerializedLambda.class);
        kryo.register(ClosureSerializer.Closure.class, (Serializer)new ClosureSerializer());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        try (Input input = new Input(Files.newInputStream(filePath, new OpenOption[0]));){
            Object object = kryo.readClassAndObject(input);
            return (T)object;
        }
    }

    public static String cleanForFilename(TaskId taskId) {
        return taskId.toString().toLowerCase().replaceAll("[,#()]+", "_").replaceAll("[^a-z0-9_]*", "");
    }

    private Path taskFile(TaskId taskId) {
        return this.basePath.resolve(PersistingContext.cleanForFilename(taskId));
    }
}

