/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.freezer;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Serialization;
import com.spotify.flo.SerializationException;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.freezer.Persisted;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistingContext
extends ForwardingEvalContext {
    private static final Logger LOG;
    private final Path basePath;
    private final Map<TaskId, Path> files = new LinkedHashMap<TaskId, Path>();

    public PersistingContext(Path basePath, EvalContext delegate) {
        super(delegate);
        this.basePath = Objects.requireNonNull(basePath);
    }

    public Map<TaskId, Path> getFiles() {
        return this.files;
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        task.inputs();
        Path file = this.taskFile(task.id());
        this.files.put(task.id(), file);
        try {
            Serialization.serialize(task, (Path)file);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return super.evaluateInternal(task, context);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<T> processFn) {
        EvalContext.Promise promise = this.promise();
        LOG.info("Will not invoke {}", (Object)taskId);
        promise.fail((Throwable)new Persisted());
        return promise.value();
    }

    static String cleanForFilename(TaskId taskId) {
        return taskId.toString().toLowerCase().replaceAll("[,#()]+", "_").replaceAll("[^a-z0-9_]*", "");
    }

    private Path taskFile(TaskId taskId) {
        return this.basePath.resolve(PersistingContext.cleanForFilename(taskId));
    }

    static {
        System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
        LOG = LoggerFactory.getLogger(PersistingContext.class);
    }
}

