/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.gcs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Preconditions;
import com.spotify.flo.Task;
import com.spotify.flo.TaskBuilder;
import com.spotify.flo.status.NotReady;
import java.io.Serializable;
import java.net.URI;

public class GcsTasks {
    private static final Storage STORAGE = (Storage)StorageOptions.getDefaultInstance().getService();

    public static Task<Blob> blobExists(String uri) {
        return GcsTasks.blobExists(URI.create(uri));
    }

    public static Task<Blob> blobExists(URI uri) {
        Preconditions.checkArgument((boolean)"gs".equals(uri.getScheme()), (Object)"Uri must have 'gs' as scheme");
        return Task.named((String)"GcsBlobExists", (Object[])new Object[]{uri}).ofType(Blob.class).process((TaskBuilder.F0 & Serializable)() -> GcsTasks.blobExistsInner(uri));
    }

    private static Blob blobExistsInner(URI uri) {
        String bucketName = uri.getAuthority();
        String prefix = uri.getPath().startsWith("/") ? uri.getPath().substring(1) : uri.getPath();
        Page list = STORAGE.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix)});
        for (Blob blob : list.iterateAll()) {
            if (!blob.getName().equals(prefix)) continue;
            return blob;
        }
        throw new NotReady();
    }
}

