/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Task;
import com.spotify.flo.TaskInfo;
import com.spotify.flo.context.ChainedListener;
import com.spotify.flo.context.FloListenerFactory;
import com.spotify.flo.context.ForkingContext;
import com.spotify.flo.context.InstrumentedContext;
import com.spotify.flo.context.Logging;
import com.spotify.flo.context.LoggingContext;
import com.spotify.flo.context.MemoizingContext;
import com.spotify.flo.context.NoopListener;
import com.spotify.flo.context.OverridingContext;
import com.spotify.flo.context.TerminationHook;
import com.spotify.flo.context.TerminationHookFactory;
import com.spotify.flo.context.TracingContext;
import com.spotify.flo.freezer.Persisted;
import com.spotify.flo.freezer.PersistingContext;
import com.spotify.flo.status.NotReady;
import com.spotify.flo.status.NotRetriable;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FloRunner<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FloRunner.class);
    private static final String MODE = "mode";
    private static final String FLO_ASYNC = "flo.async";
    private static final String FLO_WORKERS = "flo.workers";
    private static final String FLO_FORKING = "flo.forking";
    private static final String FLO_STATE_LOCATION = "flo.state.location";
    private final Logging logging = Logging.create(LOG);
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();
    private final Config config;
    private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyz0123456789";

    private FloRunner(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    private static Config defaultConfig() {
        return ConfigFactory.load((String)"flo");
    }

    public static <T> Result<T> runTask(Task<T> task, Config config) {
        return new Result<T>(super.run(task), FloRunner.loadTerminationHooks(config));
    }

    private static Iterable<TerminationHook> loadTerminationHooks(Config config) {
        ServiceLoader<TerminationHookFactory> factories = ServiceLoader.load(TerminationHookFactory.class);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(factories.iterator(), 16), false).map(factory -> Objects.requireNonNull(factory.create(config))).collect(Collectors.toList());
    }

    public static <T> Result<T> runTask(Task<T> task) {
        return FloRunner.runTask(task, FloRunner.defaultConfig());
    }

    private Future<T> run(Task<T> task) {
        this.logging.header();
        if (this.isMode("tree")) {
            this.logging.tree(TaskInfo.ofTask(task));
            return CompletableFuture.completedFuture(null);
        }
        this.logging.printPlan(TaskInfo.ofTask(task));
        EvalContext evalContext = this.createContext();
        long t0 = System.nanoTime();
        EvalContext.Value value = evalContext.evaluate(task);
        CompletableFuture future = new CompletableFuture();
        value.consume(future::complete);
        value.onFail(future::completeExceptionally);
        return future.handle((v, throwable) -> {
            new Thread(() -> this.closeables.forEach(closeable -> {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    LOG.warn("could not close {}", closeable.getClass(), (Object)e);
                }
            }), "flo-runner-closer").start();
            if (throwable != null) {
                this.logging.exception((Throwable)throwable);
                this.logging.complete(task.id(), Duration.ofNanos(System.nanoTime() - t0));
                throw new CompletionException((Throwable)throwable);
            }
            this.logging.complete(task.id(), Duration.ofNanos(System.nanoTime() - t0));
            return v;
        });
    }

    private EvalContext createContext() {
        EvalContext baseContext = this.instrument(this.createRootContext());
        if (this.isMode("persist")) {
            return MemoizingContext.composeWith((EvalContext)OverridingContext.composeWith(LoggingContext.composeWith(this.persist(baseContext), this.logging), this.logging));
        }
        return TracingContext.composeWith((EvalContext)this.forkingContext(MemoizingContext.composeWith((EvalContext)OverridingContext.composeWith(LoggingContext.composeWith(baseContext, this.logging), this.logging))));
    }

    private EvalContext createRootContext() {
        if (this.config.getBoolean(FLO_ASYNC)) {
            AtomicLong count = new AtomicLong(0L);
            ThreadFactory threadFactory = runnable -> {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("flo-worker-" + count.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            };
            ExecutorService executor = Executors.newFixedThreadPool(this.config.getInt(FLO_WORKERS), threadFactory);
            this.closeables.add(FloRunner.executorCloser(executor));
            return EvalContext.async((Executor)executor);
        }
        return EvalContext.sync();
    }

    private EvalContext instrument(EvalContext delegate) {
        ServiceLoader<FloListenerFactory> factories = ServiceLoader.load(FloListenerFactory.class);
        Object listener = new NoopListener();
        for (FloListenerFactory factory : factories) {
            InstrumentedContext.Listener newListener = Objects.requireNonNull(factory.createListener(this.config));
            listener = new ChainedListener(newListener, (InstrumentedContext.Listener)listener, this.logging);
        }
        this.closeables.add((Closeable)listener);
        return InstrumentedContext.composeWith((EvalContext)delegate, (InstrumentedContext.Listener)listener);
    }

    private EvalContext forkingContext(EvalContext baseContext) {
        boolean inDebugger = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(s -> s.contains("-agentlib:jdwp"));
        if (this.hasExplicitConfigValue(FLO_FORKING)) {
            if (this.config.getBoolean(FLO_FORKING)) {
                LOG.debug("Forking enabled (config variable flo.forking=true)");
                return ForkingContext.composeWith(baseContext);
            }
            LOG.debug("Forking disabled (config variable flo.forking=false)");
            return baseContext;
        }
        if (inDebugger) {
            LOG.debug("Debugger detected, forking disabled by default (enable by setting config variable flo.forking=true)");
            return baseContext;
        }
        LOG.debug("Debugger not detected, forking enabled by default (disable by setting config variable flo.forking=false)");
        return ForkingContext.composeWith(baseContext);
    }

    private EvalContext persist(EvalContext delegate) {
        String stateLocation = this.config.hasPath(FLO_STATE_LOCATION) ? this.config.getString(FLO_STATE_LOCATION) : "file://" + System.getProperty("user.dir");
        URI basePathUri = URI.create(stateLocation);
        Path basePath = Paths.get(basePathUri).resolve("run-" + FloRunner.randomAlphaNumeric(4));
        try {
            Files.createDirectories(basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new PersistingContext(basePath, delegate);
    }

    private boolean isMode(String mode) {
        return mode.equalsIgnoreCase(this.config.getString(MODE));
    }

    private boolean hasExplicitConfigValue(String path) {
        URL configUrl = this.config.getValue(path).origin().url();
        return configUrl == null || !configUrl.getFile().endsWith("reference.conf");
    }

    private static Closeable executorCloser(ExecutorService executorService) {
        return () -> {
            boolean terminated;
            executorService.shutdown();
            try {
                terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                terminated = false;
            }
            if (!terminated) {
                executorService.shutdownNow();
            }
        };
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public static class Result<T> {
        private final Future<T> future;
        private final Iterable<TerminationHook> terminationHooks;

        Result(Future<T> future, Iterable<TerminationHook> terminationHooks) {
            this.future = future;
            this.terminationHooks = terminationHooks;
        }

        public Future<T> future() {
            return this.future;
        }

        public void waitAndExit() {
            this.waitAndExit(System::exit);
        }

        public T value() throws ExecutionException, InterruptedException {
            return this.future.get();
        }

        void waitAndExit(Consumer<Integer> exiter) {
            try {
                this.future.get();
                this.exit(exiter, 0);
            }
            catch (ExecutionException e) {
                int status = e.getCause() instanceof NotReady ? 20 : (e.getCause() instanceof NotRetriable ? 50 : (e.getCause() instanceof Persisted ? 0 : 1));
                this.exit(exiter, status);
            }
            catch (InterruptedException | RuntimeException e) {
                this.exit(exiter, 1);
            }
        }

        private void exit(Consumer<Integer> exiter, int exitCode) {
            this.terminationHooks.forEach(hook -> {
                try {
                    hook.accept(exitCode);
                }
                catch (Exception e) {
                    LOG.warn("Termination hook failed ", (Throwable)e);
                }
            });
            exiter.accept(exitCode);
        }
    }
}

