/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.TaskId;
import com.spotify.flo.Tracing;
import com.spotify.flo.context.ForkingExecutor;
import com.spotify.flo.context.ForwardingEvalContext;
import io.grpc.Context;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;

class ForkingContext
extends ForwardingEvalContext {
    private ForkingContext(EvalContext delegate) {
        super(delegate);
    }

    static EvalContext composeWith(EvalContext baseContext) {
        return new ForkingContext(baseContext);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<T> processFn) {
        if (this.delegate == null) {
            throw new UnsupportedOperationException("nested execution not supported");
        }
        Fn<T> forkingProcessFn = this.fork(taskId, processFn);
        return this.delegate.invokeProcessFn(taskId, forkingProcessFn);
    }

    private <T> Fn<T> fork(TaskId taskId, Fn<T> fn) {
        return (Fn & Serializable)() -> {
            try (ForkingExecutor executor = new ForkingExecutor();){
                executor.environment(Collections.singletonMap("FLO_TASK_ID", taskId.toString()));
                Object t = executor.execute((Fn & Serializable)() -> {
                    try {
                        return Context.current().withValue(Tracing.TASK_ID, (Object)taskId).call(() -> fn.get());
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                return t;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

