/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.TaskId;
import com.spotify.flo.TaskInfo;
import com.spotify.flo.context.PrintUtils;
import com.spotify.flo.freezer.Persisted;
import com.spotify.flo.status.TaskStatusException;
import java.time.Duration;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;

public class Logging {
    private final Logger LOG;

    private Logging(Logger logger) {
        this.LOG = logger;
    }

    static Logging create(Logger logger) {
        return new Logging(logger);
    }

    void header() {
        this.LOG.info("Runner v{}", (Object)this.getClass().getPackage().getImplementationVersion());
        this.LOG.info("");
    }

    void willEval(TaskId id) {
    }

    void startEval(TaskId taskId) {
        this.LOG.info("{} Started", (Object)taskId);
    }

    <T> void completedValue(TaskId taskId, T value, Duration elapsed) {
        this.LOG.info("{} Completed in {} -> {}", new Object[]{taskId, DurationFormatUtils.formatDurationHMS((long)elapsed.toMillis()), value});
    }

    <T> void overriddenValue(TaskId taskId, T value) {
        this.LOG.info("{} has already been computed -> {}", (Object)taskId, value);
    }

    void overriddenValueNotFound(TaskId taskId) {
        this.LOG.info("{} has not previously been computed", (Object)taskId);
    }

    void failedValue(TaskId taskId, Throwable valueError, Duration elapsed) {
        String hms = DurationFormatUtils.formatDurationHMS((long)elapsed.toMillis());
        if (valueError instanceof TaskStatusException) {
            String exception = valueError.getClass().getSimpleName();
            this.LOG.warn("{} Signalled {} after {}", new Object[]{taskId, exception, hms});
        } else if (!(valueError instanceof Persisted)) {
            this.LOG.warn("{} Failed after {}", new Object[]{taskId, hms, valueError});
        }
    }

    void complete(TaskId taskId, Duration elapsed) {
        this.LOG.info("Total time {}", (Object)DurationFormatUtils.formatDurationHMS((long)elapsed.toMillis()));
    }

    void exception(Throwable throwable) {
        if (throwable instanceof TaskStatusException) {
            this.LOG.warn("Could not complete run: {}", (Object)throwable.getClass().getSimpleName());
        } else if (!(throwable instanceof Persisted)) {
            this.LOG.warn("Exception", throwable);
        }
    }

    void tree(TaskInfo taskInfo) {
        PrintUtils.tree(taskInfo).forEach(arg_0 -> ((Logger)this.LOG).info(arg_0));
    }

    void printPlan(TaskInfo taskInfo) {
        this.LOG.info("Evaluation plan:");
        PrintUtils.tree(taskInfo).forEach(arg_0 -> ((Logger)this.LOG).info(arg_0));
        this.LOG.info("");
    }
}

