/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.context.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;

class LoggingContext
extends ForwardingEvalContext {
    private final Logging logging;

    private LoggingContext(EvalContext baseContext, Logging logging) {
        super(baseContext);
        this.logging = Objects.requireNonNull(logging);
    }

    static EvalContext composeWith(EvalContext baseContext, Logging logging) {
        return new LoggingContext(baseContext, logging);
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        this.logging.willEval(task.id());
        return super.evaluateInternal(task, context);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<T> processFn) {
        return super.invokeProcessFn(taskId, (Fn & Serializable)() -> {
            this.logging.startEval(taskId);
            long t0 = System.nanoTime();
            try {
                Object tValue = processFn.get();
                this.logging.completedValue(taskId, tValue, Duration.ofNanos(System.nanoTime() - t0));
                return tValue;
            }
            catch (Throwable e) {
                this.logging.failedValue(taskId, e, Duration.ofNanos(System.nanoTime() - t0));
                throw e;
            }
        });
    }
}

