/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.TaskInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

final class PrintUtils {
    private PrintUtils() {
    }

    static List<String> tree(TaskInfo taskInfo) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(taskInfo.id().toString());
        PrintUtils.popSubTree(taskInfo.inputs(), lines, new Stack<Boolean>());
        return lines;
    }

    private static void popSubTree(List<TaskInfo> inputs, List<String> list, Stack<Boolean> indents) {
        for (int i = 0; i < inputs.size(); ++i) {
            TaskInfo taskInfo = inputs.get(i);
            String indent = indents.stream().map(b -> b != false ? "   " : "\u2502  ").collect(Collectors.joining());
            String branch = i < inputs.size() - 1 ? "\u251c" : "\u2514";
            String prefix = indent + branch + "\u25b8 ";
            String refArrow = taskInfo.isReference() ? " \u2934" : "";
            list.add(prefix + taskInfo.id() + refArrow);
            indents.push(i == inputs.size() - 1);
            PrintUtils.popSubTree(taskInfo.inputs(), list, indents);
            indents.pop();
        }
    }
}

