/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.util;

import com.spotify.flo.util.AutoValue_DateHour;
import com.spotify.flo.util.Date;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public abstract class DateHour
implements Comparable<DateHour>,
Serializable {
    private static final DateTimeFormatter ISO_FRAGMENT_FMT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH").withZone(ZoneOffset.UTC);

    public abstract ZonedDateTime dateTime();

    public static DateHour of(ZonedDateTime dateHour) {
        if (!dateHour.equals(dateHour.truncatedTo(ChronoUnit.HOURS))) {
            throw new IllegalArgumentException("dateHour should be truncated to the hour");
        }
        if (!dateHour.getZone().equals(ZoneOffset.UTC)) {
            throw new IllegalArgumentException("dateHour should be in UTC");
        }
        return new AutoValue_DateHour(dateHour);
    }

    public static DateHour of(int year, int month, int day, int hour) {
        return DateHour.of(ZonedDateTime.of(year, month, day, hour, 0, 0, 0, ZoneOffset.UTC));
    }

    public static DateHour of(LocalDate date, int hour) {
        return DateHour.of(date.atStartOfDay(ZoneOffset.UTC).withHour(hour));
    }

    public static DateHour of(Date date, int hour) {
        return DateHour.of(date.localDate().atStartOfDay(ZoneOffset.UTC).withHour(hour));
    }

    public static DateHour parse(String dateHour) {
        return DateHour.parse(dateHour, ISO_FRAGMENT_FMT);
    }

    public static DateHour valueOf(String dateHour) {
        return DateHour.parse(dateHour, ISO_FRAGMENT_FMT);
    }

    public static DateHour parse(String dateHour, DateTimeFormatter formatter) {
        return DateHour.of(formatter.parse((CharSequence)dateHour, ZonedDateTime::from));
    }

    public Date date() {
        return Date.of(this.dateTime().toLocalDate());
    }

    public int hour() {
        return this.dateTime().getHour();
    }

    public String format(DateTimeFormatter formatter) {
        return formatter.format(this.dateTime());
    }

    public String toString() {
        return ISO_FRAGMENT_FMT.format(this.dateTime());
    }

    @Override
    public int compareTo(DateHour other) {
        return this.dateTime().compareTo(other.dateTime());
    }
}

