/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scratch.persist;

import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.Status;
import com.spotify.flo.TaskId;
import com.spotify.scratch.persist.Dump;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okio.ByteString;

class LockHolder {
    private static final int RENEW_INTERVAL = 10;
    private final TaskId id;
    private final String request;
    private final ScheduledExecutorService scheduler;
    private final Client client = r -> CompletableFuture.completedFuture(null);
    private volatile boolean done = false;
    private volatile ScheduledFuture<?> schedule;

    LockHolder(TaskId id, String request, ScheduledExecutorService scheduler) {
        this.id = Objects.requireNonNull(id);
        this.request = Objects.requireNonNull(request);
        this.scheduler = Objects.requireNonNull(scheduler);
    }

    void lock(Consumer<Throwable> whenLocked) {
        Request lockRequest = Request.forUri((String)this.request, (String)"POST").withPayload(Dump.json(this.id));
        this.client.send(lockRequest).whenComplete((response, throwable) -> {
            if (throwable != null) {
                whenLocked.accept((Throwable)throwable);
                return;
            }
            if (response.status().code() == Status.CONFLICT.code()) {
                whenLocked.accept(new AlreadyLocked());
                return;
            }
            if (response.status().code() != Status.OK.code()) {
                whenLocked.accept(new IllegalStateException(String.format("Could not lock %s - %s %s", this.id, response.status().code(), response.status().reasonPhrase())));
                return;
            }
            this.schedule();
            whenLocked.accept(null);
        });
    }

    void unlock(Runnable whenUnlocked) {
        Request deleteRequest = Request.forUri((String)this.request, (String)"DELETE").withPayload(Dump.json(this.id));
        this.unlock(deleteRequest, whenUnlocked);
    }

    void unlock(ByteString data, Runnable whenUnlocked) {
        Request deleteRequest = Request.forUri((String)this.request, (String)"DELETE").withPayload(Dump.json(this.id, data));
        this.unlock(deleteRequest, whenUnlocked);
    }

    private void unlock(Request deleteRequest, Runnable whenUnlocked) {
        this.done = true;
        if (this.schedule != null) {
            this.schedule.cancel(false);
        }
        this.client.send(deleteRequest).thenAccept(reply -> whenUnlocked.run());
    }

    private void schedule() {
        this.schedule = this.scheduler.schedule(this::renew, 10L, TimeUnit.SECONDS);
    }

    private void renew() {
        if (this.done) {
            return;
        }
        Request renewRequest = Request.forUri((String)this.request, (String)"PUT").withPayload(Dump.json(this.id));
        this.client.send(renewRequest).whenComplete((response, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                return;
            }
            if (response.status().code() != Status.OK.code()) {
                // empty if block
            }
            this.schedule();
        });
    }

    static class AlreadyLocked
    extends Exception {
        AlreadyLocked() {
        }
    }
}

