package com.spotify.fmt;

import io.norberg.automatter.AutoMatter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
@AutoMatter.Generated
final class FormattingConfigurationBuilder {
  private boolean debug;

  private String style;

  private List<File> directoriesToFormat;

  private boolean verbose;

  private String filesNamePattern;

  private String filesPathPattern;

  private boolean skipSortingImports;

  private boolean writeReformattedFiles;

  private String processingLabel;

  public FormattingConfigurationBuilder() {
  }

  private FormattingConfigurationBuilder(FormattingConfiguration v) {
    this.debug = v.debug();
    this.style = v.style();
    List<File> _directoriesToFormat = v.directoriesToFormat();
    this.directoriesToFormat = (_directoriesToFormat == null) ? null : new ArrayList<File>(_directoriesToFormat);
    this.verbose = v.verbose();
    this.filesNamePattern = v.filesNamePattern();
    this.filesPathPattern = v.filesPathPattern();
    this.skipSortingImports = v.skipSortingImports();
    this.writeReformattedFiles = v.writeReformattedFiles();
    this.processingLabel = v.processingLabel();
  }

  private FormattingConfigurationBuilder(FormattingConfigurationBuilder v) {
    this.debug = v.debug();
    this.style = v.style();
    this.directoriesToFormat = new ArrayList<File>(v.directoriesToFormat());
    this.verbose = v.verbose();
    this.filesNamePattern = v.filesNamePattern();
    this.filesPathPattern = v.filesPathPattern();
    this.skipSortingImports = v.skipSortingImports();
    this.writeReformattedFiles = v.writeReformattedFiles();
    this.processingLabel = v.processingLabel();
  }

  public boolean debug() {
    return debug;
  }

  public FormattingConfigurationBuilder debug(boolean debug) {
    this.debug = debug;
    return this;
  }

  public String style() {
    return style;
  }

  public FormattingConfigurationBuilder style(String style) {
    if (style == null) {
      throw new NullPointerException("style");
    }
    this.style = style;
    return this;
  }

  public List<File> directoriesToFormat() {
    if (this.directoriesToFormat == null) {
      this.directoriesToFormat = new ArrayList<File>();
    }
    return directoriesToFormat;
  }

  public FormattingConfigurationBuilder directoriesToFormat(
      List<? extends File> directoriesToFormat) {
    return directoriesToFormat((Collection<? extends File>) directoriesToFormat);
  }

  public FormattingConfigurationBuilder directoriesToFormat(
      Collection<? extends File> directoriesToFormat) {
    if (directoriesToFormat == null) {
      throw new NullPointerException("directoriesToFormat");
    }
    for (File item : directoriesToFormat) {
      if (item == null) {
        throw new NullPointerException("directoriesToFormat: null item");
      }
    }
    this.directoriesToFormat = new ArrayList<File>(directoriesToFormat);
    return this;
  }

  public FormattingConfigurationBuilder directoriesToFormat(
      Iterable<? extends File> directoriesToFormat) {
    if (directoriesToFormat == null) {
      throw new NullPointerException("directoriesToFormat");
    }
    if (directoriesToFormat instanceof Collection) {
      return directoriesToFormat((Collection<? extends File>) directoriesToFormat);
    }
    return directoriesToFormat(directoriesToFormat.iterator());
  }

  public FormattingConfigurationBuilder directoriesToFormat(
      Iterator<? extends File> directoriesToFormat) {
    if (directoriesToFormat == null) {
      throw new NullPointerException("directoriesToFormat");
    }
    this.directoriesToFormat = new ArrayList<File>();
    while (directoriesToFormat.hasNext()) {
      File item = directoriesToFormat.next();
      if (item == null) {
        throw new NullPointerException("directoriesToFormat: null item");
      }
      this.directoriesToFormat.add(item);
    }
    return this;
  }

  @SafeVarargs
  @SuppressWarnings("varargs")
  public final FormattingConfigurationBuilder directoriesToFormat(File... directoriesToFormat) {
    if (directoriesToFormat == null) {
      throw new NullPointerException("directoriesToFormat");
    }
    return directoriesToFormat(Arrays.asList(directoriesToFormat));
  }

  public boolean verbose() {
    return verbose;
  }

  public FormattingConfigurationBuilder verbose(boolean verbose) {
    this.verbose = verbose;
    return this;
  }

  public String filesNamePattern() {
    return filesNamePattern;
  }

  public FormattingConfigurationBuilder filesNamePattern(String filesNamePattern) {
    if (filesNamePattern == null) {
      throw new NullPointerException("filesNamePattern");
    }
    this.filesNamePattern = filesNamePattern;
    return this;
  }

  public String filesPathPattern() {
    return filesPathPattern;
  }

  public FormattingConfigurationBuilder filesPathPattern(String filesPathPattern) {
    if (filesPathPattern == null) {
      throw new NullPointerException("filesPathPattern");
    }
    this.filesPathPattern = filesPathPattern;
    return this;
  }

  public boolean skipSortingImports() {
    return skipSortingImports;
  }

  public FormattingConfigurationBuilder skipSortingImports(boolean skipSortingImports) {
    this.skipSortingImports = skipSortingImports;
    return this;
  }

  public boolean writeReformattedFiles() {
    return writeReformattedFiles;
  }

  public FormattingConfigurationBuilder writeReformattedFiles(boolean writeReformattedFiles) {
    this.writeReformattedFiles = writeReformattedFiles;
    return this;
  }

  public String processingLabel() {
    return processingLabel;
  }

  public FormattingConfigurationBuilder processingLabel(String processingLabel) {
    if (processingLabel == null) {
      throw new NullPointerException("processingLabel");
    }
    this.processingLabel = processingLabel;
    return this;
  }

  public FormattingConfiguration build() {
    List<File> _directoriesToFormat = (directoriesToFormat != null) ? Collections.unmodifiableList(new ArrayList<File>(directoriesToFormat)) : Collections.<File>emptyList();
    return new Value(debug, style, _directoriesToFormat, verbose, filesNamePattern, filesPathPattern, skipSortingImports, writeReformattedFiles, processingLabel);
  }

  public static FormattingConfigurationBuilder from(FormattingConfiguration v) {
    return new FormattingConfigurationBuilder(v);
  }

  public static FormattingConfigurationBuilder from(FormattingConfigurationBuilder v) {
    return new FormattingConfigurationBuilder(v);
  }

  @AutoMatter.Generated
  private static final class Value implements FormattingConfiguration {
    private final boolean debug;

    private final String style;

    private final List<File> directoriesToFormat;

    private final boolean verbose;

    private final String filesNamePattern;

    private final String filesPathPattern;

    private final boolean skipSortingImports;

    private final boolean writeReformattedFiles;

    private final String processingLabel;

    private Value(@AutoMatter.Field("debug") boolean debug, @AutoMatter.Field("style") String style,
        @AutoMatter.Field("directoriesToFormat") List<File> directoriesToFormat,
        @AutoMatter.Field("verbose") boolean verbose,
        @AutoMatter.Field("filesNamePattern") String filesNamePattern,
        @AutoMatter.Field("filesPathPattern") String filesPathPattern,
        @AutoMatter.Field("skipSortingImports") boolean skipSortingImports,
        @AutoMatter.Field("writeReformattedFiles") boolean writeReformattedFiles,
        @AutoMatter.Field("processingLabel") String processingLabel) {
      if (style == null) {
        throw new NullPointerException("style");
      }
      if (filesNamePattern == null) {
        throw new NullPointerException("filesNamePattern");
      }
      if (filesPathPattern == null) {
        throw new NullPointerException("filesPathPattern");
      }
      if (processingLabel == null) {
        throw new NullPointerException("processingLabel");
      }
      this.debug = debug;
      this.style = style;
      this.directoriesToFormat = (directoriesToFormat != null) ? directoriesToFormat : Collections.<File>emptyList();
      this.verbose = verbose;
      this.filesNamePattern = filesNamePattern;
      this.filesPathPattern = filesPathPattern;
      this.skipSortingImports = skipSortingImports;
      this.writeReformattedFiles = writeReformattedFiles;
      this.processingLabel = processingLabel;
    }

    @AutoMatter.Field
    @Override
    public boolean debug() {
      return debug;
    }

    @AutoMatter.Field
    @Override
    public String style() {
      return style;
    }

    @AutoMatter.Field
    @Override
    public List<File> directoriesToFormat() {
      return directoriesToFormat;
    }

    @AutoMatter.Field
    @Override
    public boolean verbose() {
      return verbose;
    }

    @AutoMatter.Field
    @Override
    public String filesNamePattern() {
      return filesNamePattern;
    }

    @AutoMatter.Field
    @Override
    public String filesPathPattern() {
      return filesPathPattern;
    }

    @AutoMatter.Field
    @Override
    public boolean skipSortingImports() {
      return skipSortingImports;
    }

    @AutoMatter.Field
    @Override
    public boolean writeReformattedFiles() {
      return writeReformattedFiles;
    }

    @AutoMatter.Field
    @Override
    public String processingLabel() {
      return processingLabel;
    }

    public FormattingConfigurationBuilder builder() {
      return new FormattingConfigurationBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof FormattingConfiguration)) {
        return false;
      }
      final FormattingConfiguration that = (FormattingConfiguration) o;
      if (debug != that.debug()) {
        return false;
      }
      if (style != null ? !style.equals(that.style()) : that.style() != null) {
        return false;
      }
      if (directoriesToFormat != null ? !directoriesToFormat.equals(that.directoriesToFormat()) : that.directoriesToFormat() != null) {
        return false;
      }
      if (verbose != that.verbose()) {
        return false;
      }
      if (filesNamePattern != null ? !filesNamePattern.equals(that.filesNamePattern()) : that.filesNamePattern() != null) {
        return false;
      }
      if (filesPathPattern != null ? !filesPathPattern.equals(that.filesPathPattern()) : that.filesPathPattern() != null) {
        return false;
      }
      if (skipSortingImports != that.skipSortingImports()) {
        return false;
      }
      if (writeReformattedFiles != that.writeReformattedFiles()) {
        return false;
      }
      if (processingLabel != null ? !processingLabel.equals(that.processingLabel()) : that.processingLabel() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (this.debug ? 1231 : 1237);
      result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
      result = 31 * result + (this.directoriesToFormat != null ? this.directoriesToFormat.hashCode() : 0);
      result = 31 * result + (this.verbose ? 1231 : 1237);
      result = 31 * result + (this.filesNamePattern != null ? this.filesNamePattern.hashCode() : 0);
      result = 31 * result + (this.filesPathPattern != null ? this.filesPathPattern.hashCode() : 0);
      result = 31 * result + (this.skipSortingImports ? 1231 : 1237);
      result = 31 * result + (this.writeReformattedFiles ? 1231 : 1237);
      result = 31 * result + (this.processingLabel != null ? this.processingLabel.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "FormattingConfiguration{" +
      "debug=" + debug +
      ", style=" + style +
      ", directoriesToFormat=" + directoriesToFormat +
      ", verbose=" + verbose +
      ", filesNamePattern=" + filesNamePattern +
      ", filesPathPattern=" + filesPathPattern +
      ", skipSortingImports=" + skipSortingImports +
      ", writeReformattedFiles=" + writeReformattedFiles +
      ", processingLabel=" + processingLabel +
      '}';
    }
  }
}
