/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.fmt.ForkingExecutor;
import com.spotify.fmt.Formatter;
import com.spotify.fmt.FormattingConfiguration;
import com.spotify.fmt.FormattingResult;
import com.spotify.fmt.Logging;
import com.spotify.fmt.SerializableCallable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFMT
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testSourceDirectory", required=true)
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.packaging}", required=true)
    private String packaging;
    @Parameter(property="additionalSourceDirectories")
    private File[] additionalSourceDirectories;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="failOnUnknownFolder")
    private boolean failOnUnknownFolder;
    @Parameter(defaultValue=".*\\.java", property="filesNamePattern")
    private String filesNamePattern;
    @Parameter(defaultValue=".*", property="filesPathPattern")
    private String filesPathPattern;
    @Parameter(defaultValue="false", property="fmt.skip")
    private boolean skip = false;
    @Parameter(defaultValue="false", property="skipSortingImports")
    private boolean skipSortingImports = false;
    @Parameter(defaultValue="google", property="style")
    private String style;
    @Parameter(defaultValue="default", property="fmt.forkMode")
    private String forkMode;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @VisibleForTesting
    boolean useDefaultClasspathWhenForking;
    private FormattingResult result;

    public void execute() throws MojoFailureException {
        block18: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping format check");
                return;
            }
            if ("pom".equals(this.packaging)) {
                this.getLog().info((CharSequence)"Skipping format check: project uses 'pom' packaging");
                return;
            }
            if (this.skipSortingImports) {
                this.getLog().info((CharSequence)"Skipping sorting imports");
            }
            ArrayList<File> directoriesToFormat = new ArrayList<File>();
            if (this.sourceDirectory.exists()) {
                directoriesToFormat.add(this.sourceDirectory);
            } else {
                this.handleMissingDirectory("Source", this.sourceDirectory);
            }
            if (this.testSourceDirectory.exists()) {
                directoriesToFormat.add(this.testSourceDirectory);
            } else {
                this.handleMissingDirectory("Test source", this.testSourceDirectory);
            }
            for (File additionalSourceDirectory : this.additionalSourceDirectories) {
                if (additionalSourceDirectory.exists()) {
                    directoriesToFormat.add(additionalSourceDirectory);
                    continue;
                }
                this.handleMissingDirectory("Additional source", additionalSourceDirectory);
            }
            FormattingConfiguration configuration = FormattingConfiguration.builder().debug(this.getLog().isDebugEnabled()).directoriesToFormat((List<? extends File>)directoriesToFormat).style(this.style).filesNamePattern(this.filesNamePattern).filesPathPattern(this.filesPathPattern).verbose(this.verbose).skipSortingImports(this.skipSortingImports).writeReformattedFiles(this.shouldWriteReformattedFiles()).processingLabel(this.getProcessingLabel()).build();
            FormattingCallable formattingCallable = new FormattingCallable(configuration);
            try {
                if (this.shouldFork()) {
                    List<String> classpath = this.pluginArtifactMap.values().stream().map(a -> a.getFile().getAbsolutePath()).collect(Collectors.toList());
                    try (ForkingExecutor executor = new ForkingExecutor(this.getLog()).javaArgs(this.javaArgs()).classpath(classpath).withDefaultClasspath(this.useDefaultClasspathWhenForking);){
                        this.result = executor.execute(formattingCallable);
                        break block18;
                    }
                }
                this.result = formattingCallable.call();
            }
            catch (Exception e) {
                throw new MojoFailureException((Throwable)e);
            }
        }
        this.postExecute(this.result);
    }

    @VisibleForTesting
    boolean shouldFork() {
        switch (this.forkMode) {
            case "default": 
            case "always": {
                return true;
            }
            case "never": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid forkMode: " + this.forkMode + ", must be `default`, `never` or `always`");
    }

    protected void postExecute(FormattingResult result) throws MojoFailureException {
    }

    public FormattingResult getResult() {
        return this.result;
    }

    private void handleMissingDirectory(String directoryDisplayName, File directory) throws MojoFailureException {
        if (this.failOnUnknownFolder) {
            String message = directoryDisplayName + " directory '" + directory + "' does not exist, failing build (failOnUnknownFolder is true).";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.getLog().warn((CharSequence)(directoryDisplayName + " directory '" + directory + "' does not exist, ignoring."));
    }

    protected abstract boolean shouldWriteReformattedFiles();

    protected abstract String getProcessingLabel();

    private List<String> javaArgs() {
        return Arrays.asList("--add-exports", "jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "--add-opens", "jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED", "--add-opens", "jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED");
    }

    private static class FormattingCallable
    implements SerializableCallable<FormattingResult> {
        private final FormattingConfiguration configuration;

        FormattingCallable(FormattingConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public FormattingResult call() {
            Logging.configure(this.configuration.debug());
            Formatter formatter = new Formatter(this.configuration);
            return formatter.format();
        }
    }
}

