/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.AbstractFMT;
import com.spotify.fmt.FormattingResult;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class Check
extends AbstractFMT {
    @Parameter(defaultValue="true", property="displayFiles")
    private boolean displayFiles;
    @Parameter(defaultValue="100", property="displayLimit")
    private int displayLimit;

    @Override
    protected void postExecute(FormattingResult result) throws MojoFailureException {
        if (!result.nonComplyingFiles().isEmpty()) {
            String message = "Found " + result.nonComplyingFiles().size() + " non-complying files, failing build";
            this.getLog().error((CharSequence)message);
            this.getLog().error((CharSequence)"To fix formatting errors, run \"mvn com.spotify.fmt:fmt-maven-plugin:format\"");
            this.displayLimit = Math.max(1, this.displayLimit);
            if (this.displayFiles) {
                result.nonComplyingFiles().stream().limit(this.displayLimit).forEach(path -> this.getLog().error((CharSequence)("Non complying file: " + path)));
                if (result.nonComplyingFiles().size() > this.displayLimit) {
                    this.getLog().error((CharSequence)String.format("... and %d more files.", result.nonComplyingFiles().size() - this.displayLimit));
                }
            }
            throw new MojoFailureException(message);
        }
    }

    @Override
    protected boolean shouldWriteReformattedFiles() {
        return false;
    }

    @Override
    protected String getProcessingLabel() {
        return "non-complying";
    }
}

