/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.AbstractFMT;
import com.spotify.fmt.FormattingResult;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class Check
extends AbstractFMT {
    @Parameter(defaultValue="true", property="displayFiles")
    private boolean displayFiles;
    @Parameter(defaultValue="100", property="displayLimit")
    private int displayLimit;
    @Parameter(defaultValue="true", property="fmt.failOnError")
    private boolean failOnError;

    @Override
    protected void postExecute(FormattingResult result) throws MojoFailureException {
        Consumer<String> messageConsumer;
        Consumer<String> consumer = this.failOnError ? arg_0 -> ((Log)this.getLog()).error(arg_0) : (messageConsumer = arg_0 -> ((Log)this.getLog()).warn(arg_0));
        if (!result.nonComplyingFiles().isEmpty()) {
            String message = "Found " + result.nonComplyingFiles().size() + " non-complying files" + (this.failOnError ? ", failing build" : "");
            messageConsumer.accept(message);
            messageConsumer.accept("To fix formatting errors, run \"mvn com.spotify.fmt:fmt-maven-plugin:format\"");
            this.displayLimit = Math.max(1, this.displayLimit);
            if (this.displayFiles) {
                result.nonComplyingFiles().stream().limit(this.displayLimit).forEach(path -> messageConsumer.accept("Non complying file: " + path));
                if (result.nonComplyingFiles().size() > this.displayLimit) {
                    messageConsumer.accept(String.format("... and %d more files.", result.nonComplyingFiles().size() - this.displayLimit));
                }
            }
            if (this.failOnError) {
                throw new MojoFailureException(message);
            }
        }
    }

    @Override
    protected boolean shouldWriteReformattedFiles() {
        return false;
    }

    @Override
    protected String getProcessingLabel() {
        return "non-complying";
    }
}

