/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.FormattingResult;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@AutoMatter.Generated
final class FormattingResultBuilder {
    private List<String> processedFiles;
    private List<String> nonComplyingFiles;

    public FormattingResultBuilder() {
    }

    private FormattingResultBuilder(FormattingResult v) {
        List<String> _processedFiles = v.processedFiles();
        this.processedFiles = _processedFiles == null ? null : new ArrayList<String>(_processedFiles);
        List<String> _nonComplyingFiles = v.nonComplyingFiles();
        this.nonComplyingFiles = _nonComplyingFiles == null ? null : new ArrayList<String>(_nonComplyingFiles);
    }

    private FormattingResultBuilder(FormattingResultBuilder v) {
        this.processedFiles = new ArrayList<String>(v.processedFiles());
        this.nonComplyingFiles = new ArrayList<String>(v.nonComplyingFiles());
    }

    public List<String> processedFiles() {
        if (this.processedFiles == null) {
            this.processedFiles = new ArrayList<String>();
        }
        return this.processedFiles;
    }

    public FormattingResultBuilder processedFiles(List<? extends String> processedFiles) {
        return this.processedFiles((Collection<? extends String>)processedFiles);
    }

    public FormattingResultBuilder processedFiles(Collection<? extends String> processedFiles) {
        if (processedFiles == null) {
            throw new NullPointerException("processedFiles");
        }
        for (String string : processedFiles) {
            if (string != null) continue;
            throw new NullPointerException("processedFiles: null item");
        }
        this.processedFiles = new ArrayList<String>(processedFiles);
        return this;
    }

    public FormattingResultBuilder processedFiles(Iterable<? extends String> processedFiles) {
        if (processedFiles == null) {
            throw new NullPointerException("processedFiles");
        }
        if (processedFiles instanceof Collection) {
            return this.processedFiles((Collection)processedFiles);
        }
        return this.processedFiles(processedFiles.iterator());
    }

    public FormattingResultBuilder processedFiles(Iterator<? extends String> processedFiles) {
        if (processedFiles == null) {
            throw new NullPointerException("processedFiles");
        }
        this.processedFiles = new ArrayList<String>();
        while (processedFiles.hasNext()) {
            String item = processedFiles.next();
            if (item == null) {
                throw new NullPointerException("processedFiles: null item");
            }
            this.processedFiles.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final FormattingResultBuilder processedFiles(String ... processedFiles) {
        if (processedFiles == null) {
            throw new NullPointerException("processedFiles");
        }
        return this.processedFiles(Arrays.asList(processedFiles));
    }

    public FormattingResultBuilder addProcessedFile(String processedFile) {
        if (processedFile == null) {
            throw new NullPointerException("processedFile");
        }
        if (this.processedFiles == null) {
            this.processedFiles = new ArrayList<String>();
        }
        this.processedFiles.add(processedFile);
        return this;
    }

    public List<String> nonComplyingFiles() {
        if (this.nonComplyingFiles == null) {
            this.nonComplyingFiles = new ArrayList<String>();
        }
        return this.nonComplyingFiles;
    }

    public FormattingResultBuilder nonComplyingFiles(List<? extends String> nonComplyingFiles) {
        return this.nonComplyingFiles((Collection<? extends String>)nonComplyingFiles);
    }

    public FormattingResultBuilder nonComplyingFiles(Collection<? extends String> nonComplyingFiles) {
        if (nonComplyingFiles == null) {
            throw new NullPointerException("nonComplyingFiles");
        }
        for (String string : nonComplyingFiles) {
            if (string != null) continue;
            throw new NullPointerException("nonComplyingFiles: null item");
        }
        this.nonComplyingFiles = new ArrayList<String>(nonComplyingFiles);
        return this;
    }

    public FormattingResultBuilder nonComplyingFiles(Iterable<? extends String> nonComplyingFiles) {
        if (nonComplyingFiles == null) {
            throw new NullPointerException("nonComplyingFiles");
        }
        if (nonComplyingFiles instanceof Collection) {
            return this.nonComplyingFiles((Collection)nonComplyingFiles);
        }
        return this.nonComplyingFiles(nonComplyingFiles.iterator());
    }

    public FormattingResultBuilder nonComplyingFiles(Iterator<? extends String> nonComplyingFiles) {
        if (nonComplyingFiles == null) {
            throw new NullPointerException("nonComplyingFiles");
        }
        this.nonComplyingFiles = new ArrayList<String>();
        while (nonComplyingFiles.hasNext()) {
            String item = nonComplyingFiles.next();
            if (item == null) {
                throw new NullPointerException("nonComplyingFiles: null item");
            }
            this.nonComplyingFiles.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final FormattingResultBuilder nonComplyingFiles(String ... nonComplyingFiles) {
        if (nonComplyingFiles == null) {
            throw new NullPointerException("nonComplyingFiles");
        }
        return this.nonComplyingFiles(Arrays.asList(nonComplyingFiles));
    }

    public FormattingResultBuilder addNonComplyingFile(String nonComplyingFile) {
        if (nonComplyingFile == null) {
            throw new NullPointerException("nonComplyingFile");
        }
        if (this.nonComplyingFiles == null) {
            this.nonComplyingFiles = new ArrayList<String>();
        }
        this.nonComplyingFiles.add(nonComplyingFile);
        return this;
    }

    public FormattingResult build() {
        List _processedFiles = this.processedFiles != null ? Collections.unmodifiableList(new ArrayList<String>(this.processedFiles)) : Collections.emptyList();
        List _nonComplyingFiles = this.nonComplyingFiles != null ? Collections.unmodifiableList(new ArrayList<String>(this.nonComplyingFiles)) : Collections.emptyList();
        return new Value(_processedFiles, _nonComplyingFiles);
    }

    public static FormattingResultBuilder from(FormattingResult v) {
        return new FormattingResultBuilder(v);
    }

    public static FormattingResultBuilder from(FormattingResultBuilder v) {
        return new FormattingResultBuilder(v);
    }

    @AutoMatter.Generated
    private static final class Value
    implements FormattingResult {
        private final List<String> processedFiles;
        private final List<String> nonComplyingFiles;

        private Value(@AutoMatter.Field(value="processedFiles") List<String> processedFiles, @AutoMatter.Field(value="nonComplyingFiles") List<String> nonComplyingFiles) {
            this.processedFiles = processedFiles != null ? processedFiles : Collections.emptyList();
            this.nonComplyingFiles = nonComplyingFiles != null ? nonComplyingFiles : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public List<String> processedFiles() {
            return this.processedFiles;
        }

        @Override
        @AutoMatter.Field
        public List<String> nonComplyingFiles() {
            return this.nonComplyingFiles;
        }

        @Override
        public FormattingResultBuilder builder() {
            return new FormattingResultBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FormattingResult)) {
                return false;
            }
            FormattingResult that = (FormattingResult)o;
            if (this.processedFiles != null ? !this.processedFiles.equals(that.processedFiles()) : that.processedFiles() != null) {
                return false;
            }
            return !(this.nonComplyingFiles != null ? !this.nonComplyingFiles.equals(that.nonComplyingFiles()) : that.nonComplyingFiles() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.processedFiles != null ? this.processedFiles.hashCode() : 0);
            result = 31 * result + (this.nonComplyingFiles != null ? this.nonComplyingFiles.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FormattingResult{processedFiles=" + this.processedFiles + ", nonComplyingFiles=" + this.nonComplyingFiles + "}";
        }
    }
}

