/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.client.Utils;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class YammerMetrics
implements Metrics {
    public static final String GROUP = "com.spotify.folsom";
    private final Timer gets;
    private final Meter getHits;
    private final Meter getMisses;
    private final Meter getSuccesses;
    private final Meter getFailures;
    private final Timer multigets;
    private final Meter multigetSuccesses;
    private final Meter multigetFailures;
    private final Timer sets;
    private final Meter setSuccesses;
    private final Meter setFailures;
    private final Timer deletes;
    private final Meter deleteSuccesses;
    private final Meter deleteFailures;
    private final Timer incrDecrs;
    private final Meter incrDecrSuccesses;
    private final Meter incrDecrFailures;
    private final Timer touches;
    private final Meter touchSuccesses;
    private final Meter touchFailures;
    private final Set<Metrics.OutstandingRequestsGauge> gauges = new CopyOnWriteArraySet<Metrics.OutstandingRequestsGauge>();

    public YammerMetrics(MetricsRegistry registry) {
        this.gets = registry.newTimer(this.name("get", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.getSuccesses = registry.newMeter(this.name("get", "successes"), "Successes", TimeUnit.SECONDS);
        this.getHits = registry.newMeter(this.name("get", "hits"), "Hits", TimeUnit.SECONDS);
        this.getMisses = registry.newMeter(this.name("get", "misses"), "Misses", TimeUnit.SECONDS);
        this.getFailures = registry.newMeter(this.name("get", "failures"), "Failures", TimeUnit.SECONDS);
        this.multigets = registry.newTimer(this.name("multiget", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.multigetSuccesses = registry.newMeter(this.name("multiget", "successes"), "Successes", TimeUnit.SECONDS);
        this.multigetFailures = registry.newMeter(this.name("multiget", "failures"), "Failures", TimeUnit.SECONDS);
        this.sets = registry.newTimer(this.name("set", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.setSuccesses = registry.newMeter(this.name("set", "successes"), "Successes", TimeUnit.SECONDS);
        this.setFailures = registry.newMeter(this.name("set", "failures"), "Failures", TimeUnit.SECONDS);
        this.deletes = registry.newTimer(this.name("delete", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.deleteSuccesses = registry.newMeter(this.name("delete", "successes"), "Successes", TimeUnit.SECONDS);
        this.deleteFailures = registry.newMeter(this.name("delete", "failures"), "Failures", TimeUnit.SECONDS);
        this.incrDecrs = registry.newTimer(this.name("incrdecr", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.incrDecrSuccesses = registry.newMeter(this.name("incrdecr", "successes"), "Successes", TimeUnit.SECONDS);
        this.incrDecrFailures = registry.newMeter(this.name("incrdecr", "failures"), "Failures", TimeUnit.SECONDS);
        this.touches = registry.newTimer(this.name("touch", "requests"), TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.touchSuccesses = registry.newMeter(this.name("touch", "successes"), "Successes", TimeUnit.SECONDS);
        this.touchFailures = registry.newMeter(this.name("touch", "failures"), "Failures", TimeUnit.SECONDS);
        MetricName gaugeName = this.name("outstandingRequests", "count");
        registry.newGauge(gaugeName, (Gauge)new Gauge<Long>(){

            public Long value() {
                return YammerMetrics.this.getOutstandingRequests();
            }
        });
        MetricName globalConnections = this.name("global-connections", "count");
        registry.newGauge(globalConnections, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return Utils.getGlobalConnectionCount();
            }
        });
    }

    @VisibleForTesting
    long getOutstandingRequests() {
        return this.gauges.stream().mapToLong(Metrics.OutstandingRequestsGauge::getOutstandingRequests).sum();
    }

    private MetricName name(String type, String name) {
        return new MetricName(GROUP, type, name);
    }

    public void measureGetFuture(CompletionStage<GetResult<byte[]>> future) {
        TimerContext ctx = this.gets.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.getSuccesses.mark();
                if (result != null) {
                    this.getHits.mark();
                } else {
                    this.getMisses.mark();
                }
            } else {
                this.getFailures.mark();
            }
        });
    }

    public void measureMultigetFuture(CompletionStage<List<GetResult<byte[]>>> future) {
        TimerContext ctx = this.multigets.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.multigetSuccesses.mark();
                int hits = 0;
                int total = result.size();
                for (int i = 0; i < total; ++i) {
                    if (result.get(i) == null) continue;
                    ++hits;
                }
                this.getHits.mark((long)hits);
                this.getMisses.mark((long)(total - hits));
            } else {
                this.multigetFailures.mark();
            }
        });
    }

    public void measureDeleteFuture(CompletionStage<MemcacheStatus> future) {
        TimerContext ctx = this.deletes.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.deleteSuccesses.mark();
            } else {
                this.deleteFailures.mark();
            }
        });
    }

    public void measureSetFuture(CompletionStage<MemcacheStatus> future) {
        TimerContext ctx = this.sets.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.setSuccesses.mark();
            } else {
                this.setFailures.mark();
            }
        });
    }

    public void measureIncrDecrFuture(CompletionStage<Long> future) {
        TimerContext ctx = this.incrDecrs.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.incrDecrSuccesses.mark();
            } else {
                this.incrDecrFailures.mark();
            }
        });
    }

    public void measureTouchFuture(CompletionStage<MemcacheStatus> future) {
        TimerContext ctx = this.touches.time();
        future.whenComplete((result, t) -> {
            ctx.stop();
            if (t == null) {
                this.touchSuccesses.mark();
            } else {
                this.touchFailures.mark();
            }
        });
    }

    public void registerOutstandingRequestsGauge(Metrics.OutstandingRequestsGauge gauge) {
        this.gauges.add(gauge);
    }

    public void unregisterOutstandingRequestsGauge(Metrics.OutstandingRequestsGauge gauge) {
        this.gauges.remove(gauge);
    }

    public Timer getGets() {
        return this.gets;
    }

    public Meter getGetHits() {
        return this.getHits;
    }

    public Meter getGetMisses() {
        return this.getMisses;
    }

    public Meter getGetSuccesses() {
        return this.getSuccesses;
    }

    public Meter getGetFailures() {
        return this.getFailures;
    }

    public Timer getMultigets() {
        return this.multigets;
    }

    public Meter getMultigetSuccesses() {
        return this.multigetSuccesses;
    }

    public Meter getMultigetFailures() {
        return this.multigetFailures;
    }

    public Timer getSets() {
        return this.sets;
    }

    public Meter getSetSuccesses() {
        return this.setSuccesses;
    }

    public Meter getSetFailures() {
        return this.setFailures;
    }

    public Timer getDeletes() {
        return this.deletes;
    }

    public Meter getDeleteSuccesses() {
        return this.deleteSuccesses;
    }

    public Meter getDeleteFailures() {
        return this.deleteFailures;
    }

    public Timer getIncrDecrs() {
        return this.incrDecrs;
    }

    public Meter getIncrDecrSuccesses() {
        return this.incrDecrSuccesses;
    }

    public Meter getIncrDecrFailures() {
        return this.incrDecrFailures;
    }

    public Timer getTouches() {
        return this.touches;
    }

    public Meter getTouchSuccesses() {
        return this.touchSuccesses;
    }

    public Meter getTouchFailures() {
        return this.touchFailures;
    }
}

