/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.DnsSrvResolvers;
import com.spotify.folsom.AsciiMemcacheClient;
import com.spotify.folsom.BackoffFunction;
import com.spotify.folsom.BinaryMemcacheClient;
import com.spotify.folsom.ExponentialBackoff;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.SrvKetamaClient;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.UncaughtExceptionHandler;
import com.spotify.folsom.client.NoopMetrics;
import com.spotify.folsom.client.ascii.DefaultAsciiMemcacheClient;
import com.spotify.folsom.client.binary.DefaultBinaryMemcacheClient;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.KetamaMemcacheClient;
import com.spotify.folsom.reconnect.ReconnectingClient;
import com.spotify.folsom.retry.RetryingClient;
import com.spotify.folsom.roundrobin.RoundRobinMemcacheClient;
import com.spotify.folsom.transcoder.ByteArrayTranscoder;
import com.spotify.folsom.transcoder.StringTranscoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MemcacheClientBuilder<V> {
    private static final int DEFAULT_MAX_OUTSTANDING = 1000;
    private static final String DEFAULT_HOSTNAME = "127.0.0.1";
    private static final int DEFAULT_PORT = 11211;
    private List<HostAndPort> addresses = null;
    private int maxOutstandingRequests = 1000;
    private final Transcoder<V> valueTranscoder;
    private Metrics metrics = NoopMetrics.INSTANCE;
    private BackoffFunction backoffFunction = new ExponentialBackoff(10L, 60000L, 2.5);
    private int connections = 1;
    private boolean retry = true;
    private Executor executor;
    private Charset charset = Charsets.UTF_8;
    private DnsSrvResolver srvResolver;
    private String srvRecord;
    private long dnsRefreshPeriod = 60000L;
    private long shutdownDelay = 60000L;
    private long timeoutMillis = 3000L;

    public static MemcacheClientBuilder<byte[]> newByteArrayClient() {
        return new MemcacheClientBuilder<byte[]>(ByteArrayTranscoder.INSTANCE);
    }

    public static MemcacheClientBuilder<String> newStringClient() {
        return MemcacheClientBuilder.newStringClient(Charsets.UTF_8);
    }

    public static MemcacheClientBuilder<String> newStringClient(Charset charset) {
        return new MemcacheClientBuilder<String>(new StringTranscoder(charset));
    }

    public MemcacheClientBuilder(Transcoder<V> valueTranscoder) {
        this.valueTranscoder = valueTranscoder;
    }

    public MemcacheClientBuilder<V> withKeyCharset(Charset charset) {
        this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
        return this;
    }

    public MemcacheClientBuilder<V> withAddress(String hostname) {
        return this.withAddress(HostAndPort.fromParts((String)hostname, (int)11211));
    }

    public MemcacheClientBuilder<V> withAddress(HostAndPort address) {
        this.addresses = ImmutableList.of((Object)address);
        return this;
    }

    public MemcacheClientBuilder<V> withAddresses(List<HostAndPort> addresses) {
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0);
        this.addresses = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(addresses)));
        return this;
    }

    public MemcacheClientBuilder<V> withSRVRecord(String srvRecord) {
        this.srvRecord = (String)Preconditions.checkNotNull((Object)srvRecord);
        return this;
    }

    public MemcacheClientBuilder<V> withSRVRefreshPeriod(long periodMillis) {
        this.dnsRefreshPeriod = periodMillis;
        return this;
    }

    public MemcacheClientBuilder<V> withSRVShutdownDelay(long shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
        return this;
    }

    public MemcacheClientBuilder<V> withSrvResolver(DnsSrvResolver srvResolver) {
        this.srvResolver = (DnsSrvResolver)Preconditions.checkNotNull((Object)srvResolver, (Object)"srvResolver");
        return this;
    }

    public MemcacheClientBuilder<V> withMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public MemcacheClientBuilder<V> withMaxOutstandingRequests(int maxOutstandingRequests) {
        this.maxOutstandingRequests = maxOutstandingRequests;
        return this;
    }

    public MemcacheClientBuilder<V> withBackoff(BackoffFunction backoffFunction) {
        this.backoffFunction = backoffFunction;
        return this;
    }

    public MemcacheClientBuilder<V> withRetry(boolean retry) {
        this.retry = retry;
        return this;
    }

    public MemcacheClientBuilder<V> withReplyExecutor(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    public MemcacheClientBuilder<V> withConnections(int connections) {
        if (connections < 1) {
            throw new IllegalArgumentException("connections must be at least 1");
        }
        this.connections = connections;
        return this;
    }

    public MemcacheClientBuilder<V> withRequestTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public BinaryMemcacheClient<V> connectBinary() {
        return new DefaultBinaryMemcacheClient<V>(this.connectRaw(true), this.metrics, this.valueTranscoder, this.charset);
    }

    public AsciiMemcacheClient<V> connectAscii() {
        return new DefaultAsciiMemcacheClient<V>(this.connectRaw(false), this.metrics, this.valueTranscoder, this.charset);
    }

    protected RawMemcacheClient connectRaw(boolean binary) {
        RawMemcacheClient client;
        ImmutableList addresses = this.addresses;
        if (this.srvRecord != null) {
            if (addresses != null) {
                throw new IllegalStateException("You may not specify both srvRecord and addresses");
            }
            client = this.createSRVClient(binary);
        } else {
            if (addresses == null) {
                addresses = ImmutableList.of((Object)HostAndPort.fromParts((String)DEFAULT_HOSTNAME, (int)11211));
            }
            List<RawMemcacheClient> clients = this.createClients((List<HostAndPort>)addresses, binary);
            if (addresses.size() > 1) {
                Preconditions.checkState((clients.size() == addresses.size() ? 1 : 0) != 0);
                ArrayList aac = Lists.newArrayListWithCapacity((int)clients.size());
                for (int i = 0; i < clients.size(); ++i) {
                    HostAndPort address = (HostAndPort)addresses.get(i);
                    aac.add(new AddressAndClient(address, clients.get(i)));
                }
                client = new KetamaMemcacheClient(aac);
            } else {
                client = clients.get(0);
            }
        }
        if (this.retry) {
            return new RetryingClient(client);
        }
        return client;
    }

    private List<RawMemcacheClient> createClients(List<HostAndPort> addresses, boolean binary) {
        ArrayList clients = Lists.newArrayListWithCapacity((int)addresses.size());
        for (HostAndPort address : addresses) {
            clients.add(this.createClient(address, binary));
        }
        return clients;
    }

    private RawMemcacheClient createSRVClient(final boolean binary) {
        DnsSrvResolver resolver = this.srvResolver;
        if (resolver == null) {
            resolver = DefaultDnsResolver.INSTANCE;
        }
        SrvKetamaClient client = new SrvKetamaClient(this.srvRecord, resolver, DefaultScheduledExecutor.INSTANCE, this.dnsRefreshPeriod, TimeUnit.MILLISECONDS, new SrvKetamaClient.Connector(){

            @Override
            public RawMemcacheClient connect(HostAndPort input) {
                return MemcacheClientBuilder.this.createClient(input, binary);
            }
        }, this.shutdownDelay, TimeUnit.MILLISECONDS);
        client.start();
        return client;
    }

    private RawMemcacheClient createClient(HostAndPort address, boolean binary) {
        if (this.connections == 1) {
            return this.createReconnectingClient(address, binary);
        }
        ArrayList clients = Lists.newArrayList();
        for (int i = 0; i < this.connections; ++i) {
            clients.add(this.createReconnectingClient(address, binary));
        }
        return new RoundRobinMemcacheClient(clients);
    }

    private RawMemcacheClient createReconnectingClient(HostAndPort address, boolean binary) {
        Executor executor = this.executor != null ? this.executor : DefaultExecutor.INSTANCE;
        return new ReconnectingClient(this.backoffFunction, ReconnectingClient.singletonExecutor(), address, this.maxOutstandingRequests, binary, executor, this.timeoutMillis, this.charset);
    }

    private static class DefaultScheduledExecutor {
        private static final ScheduledExecutorService INSTANCE = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("folsom-default-scheduled-executor").build());

        private DefaultScheduledExecutor() {
        }
    }

    private static class DefaultDnsResolver {
        private static final DnsSrvResolver INSTANCE = DnsSrvResolvers.newBuilder().cachingLookups(true).retainingDataOnFailures(true).build();

        private DefaultDnsResolver() {
        }
    }

    private static class DefaultExecutor {
        private static final Executor INSTANCE = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, new UncaughtExceptionHandler(), true);

        private DefaultExecutor() {
        }
    }
}

