/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import java.io.IOException;

public enum MemcacheStatus {
    OK,
    KEY_NOT_FOUND,
    KEY_EXISTS,
    VALUE_TOO_LARGE,
    INVALID_ARGUMENTS,
    ITEM_NOT_STORED;


    public static MemcacheStatus fromInt(int status) throws IOException {
        switch (status) {
            case 0: {
                return OK;
            }
            case 1: {
                return KEY_NOT_FOUND;
            }
            case 2: {
                return KEY_EXISTS;
            }
            case 3: {
                return VALUE_TOO_LARGE;
            }
            case 4: {
                return INVALID_ARGUMENTS;
            }
            case 5: {
                return ITEM_NOT_STORED;
            }
        }
        throw new IOException(String.format("Unknown status code: 0x%2x", status));
    }
}

