/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.ConnectFuture;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.NotConnectedClient;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.KetamaMemcacheClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvKetamaClient
extends AbstractRawMemcacheClient {
    private static final Logger log = LoggerFactory.getLogger(SrvKetamaClient.class);
    private final ScheduledExecutorService executor;
    private final String srvRecord;
    private final DnsSrvResolver srvResolver;
    private final long period;
    private final TimeUnit periodUnit;
    private final Connector connector;
    private final long shutdownDelay;
    private final TimeUnit shutdownUnit;
    private final MyConnectionChangeListener listener = new MyConnectionChangeListener();
    private ScheduledFuture<?> refreshJob;
    private final Object sync = new Object();
    private volatile List<HostAndPort> addresses = Collections.emptyList();
    private volatile RawMemcacheClient currentClient;
    private volatile RawMemcacheClient pendingClient = null;
    private boolean shutdown = false;

    public SrvKetamaClient(String srvRecord, DnsSrvResolver srvResolver, ScheduledExecutorService executor, long period, TimeUnit periodUnit, Connector connector, long shutdownDelay, TimeUnit shutdownUnit) {
        this.srvRecord = srvRecord;
        this.srvResolver = srvResolver;
        this.period = period;
        this.periodUnit = periodUnit;
        this.connector = connector;
        this.shutdownDelay = shutdownDelay;
        this.shutdownUnit = shutdownUnit;
        this.executor = executor;
        this.currentClient = NotConnectedClient.INSTANCE;
        this.currentClient.registerForConnectionChanges(this.listener);
    }

    public void start() {
        if (this.refreshJob != null) {
            throw new RuntimeException("You may only start this once");
        }
        this.refreshJob = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SrvKetamaClient.this.updateDNS();
            }
        }, 0L, this.period, this.periodUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDNS() {
        Object object = this.sync;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            List newAddresses = Ordering.from((Comparator)HostAndPortComparator.INSTANCE).sortedCopy((Iterable)this.srvResolver.resolve(this.srvRecord));
            if (!newAddresses.equals(this.addresses)) {
                this.addresses = newAddresses;
                log.info("Connecting to " + newAddresses);
                List<AddressAndClient> addressAndClients = this.getAddressesAndClients(newAddresses);
                this.setPendingClient(addressAndClients);
            }
        }
    }

    private List<AddressAndClient> getAddressesAndClients(List<HostAndPort> newAddresses) {
        ArrayList res = Lists.newArrayListWithCapacity((int)newAddresses.size());
        for (HostAndPort address : newAddresses) {
            res.add(new AddressAndClient(address, this.connector.connect(address)));
        }
        return res;
    }

    @Override
    public <T> ListenableFuture<T> send(Request<T> request) {
        return this.currentClient.send(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        RawMemcacheClient pending;
        if (this.refreshJob != null) {
            this.refreshJob.cancel(false);
        }
        Object object = this.sync;
        synchronized (object) {
            this.shutdown = true;
            pending = this.pendingClient;
            this.pendingClient = null;
            this.currentClient.shutdown();
        }
        if (pending != null) {
            pending.unregisterForConnectionChanges(this.listener);
            pending.shutdown();
        }
    }

    @Override
    public boolean isConnected() {
        return this.currentClient.isConnected();
    }

    @Override
    public int numTotalConnections() {
        return this.currentClient.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.currentClient.numActiveConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingClient(List<AddressAndClient> addressAndClients) {
        RawMemcacheClient oldPending;
        final KetamaMemcacheClient newPending = new KetamaMemcacheClient((Collection<AddressAndClient>)addressAndClients);
        newPending.registerForConnectionChanges(this.listener);
        Object object = this.sync;
        synchronized (object) {
            oldPending = this.pendingClient;
            this.pendingClient = newPending;
        }
        ListenableFuture<Void> future = ConnectFuture.connectFuture(newPending);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable Void result) {
                RawMemcacheClient oldClient;
                Object object = SrvKetamaClient.this.sync;
                synchronized (object) {
                    if (newPending != SrvKetamaClient.this.pendingClient) {
                        return;
                    }
                    oldClient = SrvKetamaClient.this.currentClient;
                    SrvKetamaClient.this.currentClient = SrvKetamaClient.this.pendingClient;
                    SrvKetamaClient.this.pendingClient = null;
                }
                SrvKetamaClient.this.notifyConnectionChange();
                SrvKetamaClient.this.executor.schedule(new ShutdownJob(oldClient), SrvKetamaClient.this.shutdownDelay, SrvKetamaClient.this.shutdownUnit);
            }

            public void onFailure(Throwable t) {
                throw new RuntimeException("Programmer bug - this is unreachable code");
            }
        });
        if (oldPending != null) {
            oldPending.unregisterForConnectionChanges(this.listener);
            oldPending.shutdown();
        }
    }

    private class MyConnectionChangeListener
    implements ConnectionChangeListener {
        private MyConnectionChangeListener() {
        }

        @Override
        public void connectionChanged(RawMemcacheClient client) {
            SrvKetamaClient.this.notifyConnectionChange();
        }
    }

    private class ShutdownJob
    implements Runnable {
        private final RawMemcacheClient oldClient;

        public ShutdownJob(RawMemcacheClient oldClient) {
            this.oldClient = oldClient;
        }

        @Override
        public void run() {
            this.oldClient.unregisterForConnectionChanges(SrvKetamaClient.this.listener);
            this.oldClient.shutdown();
        }
    }

    private static class HostAndPortComparator
    implements Comparator<HostAndPort> {
        private static final HostAndPortComparator INSTANCE = new HostAndPortComparator();

        private HostAndPortComparator() {
        }

        @Override
        public int compare(HostAndPort o1, HostAndPort o2) {
            int cmp = o1.getHostText().compareTo(o2.getHostText());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(o1.getPort(), o2.getPort());
        }
    }

    public static interface Connector {
        public RawMemcacheClient connect(HostAndPort var1);
    }
}

