/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.base.Preconditions;
import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.RawMemcacheClient;
import java.util.Collection;

public abstract class AbstractMultiMemcacheClient
extends AbstractRawMemcacheClient
implements ConnectionChangeListener {
    protected final Collection<RawMemcacheClient> clients;

    public AbstractMultiMemcacheClient(Collection<RawMemcacheClient> clients) {
        Preconditions.checkArgument((!clients.isEmpty() ? 1 : 0) != 0, (Object)"clients must not be empty");
        this.clients = clients;
        for (RawMemcacheClient client : clients) {
            client.registerForConnectionChanges(this);
        }
    }

    @Override
    public void shutdown() {
        for (RawMemcacheClient client : this.clients) {
            client.shutdown();
        }
    }

    @Override
    public boolean isConnected() {
        for (RawMemcacheClient client : this.clients) {
            if (!client.isConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int numTotalConnections() {
        int sum = 0;
        for (RawMemcacheClient client : this.clients) {
            sum += client.numTotalConnections();
        }
        return sum;
    }

    @Override
    public int numActiveConnections() {
        int sum = 0;
        for (RawMemcacheClient client : this.clients) {
            sum += client.numActiveConnections();
        }
        return sum;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.clients + ")";
    }

    @Override
    public void connectionChanged(RawMemcacheClient client) {
        this.notifyConnectionChange();
    }
}

