/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class BatchFlusher {
    private static final int DEFAULT_MAX_PENDING = 64;
    private final Channel channel;
    private final EventLoop eventLoop;
    private final int maxPending;
    private final AtomicIntegerFieldUpdater<BatchFlusher> WOKEN = AtomicIntegerFieldUpdater.newUpdater(BatchFlusher.class, "woken");
    private volatile int woken;
    private int pending;
    private final Runnable flush = new Runnable(){

        @Override
        public void run() {
            BatchFlusher.this.pending = 0;
            BatchFlusher.this.channel.flush();
        }
    };
    private final Runnable wakeup = new Runnable(){

        @Override
        public void run() {
            BatchFlusher.this.woken = 0;
            BatchFlusher.this.eventLoop.execute(BatchFlusher.this.flush);
        }
    };

    public BatchFlusher(Channel channel) {
        this(channel, 64);
    }

    public BatchFlusher(Channel channel, int maxPending) {
        this.channel = channel;
        this.maxPending = maxPending;
        this.eventLoop = channel.eventLoop();
    }

    public void flush() {
        if (this.eventLoop.inEventLoop()) {
            ++this.pending;
            if (this.pending >= this.maxPending) {
                this.pending = 0;
                this.channel.flush();
            }
        }
        if (this.woken == 0 && this.WOKEN.compareAndSet(this, 0, 1)) {
            this.woken = 1;
            this.eventLoop.execute(this.wakeup);
        }
    }
}

