/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public abstract class Request<V>
extends AbstractFuture<V> {
    protected final byte[] key;
    protected final int opaque;

    protected Request(String key, Charset charset, int opaque) {
        this(Request.encodeKey(key, charset), opaque);
    }

    protected Request(byte[] key, int opaque) {
        this.key = key;
        this.opaque = opaque << 8 & 0xFFFFFF00;
    }

    protected static ByteBuf toBuffer(ByteBufAllocator alloc, ByteBuffer dst) {
        return Request.toBuffer(alloc, dst, 0);
    }

    public byte[] getKey() {
        return this.key;
    }

    public abstract ByteBuf writeRequest(ByteBufAllocator var1, ByteBuffer var2);

    public void fail(Throwable e) {
        this.setException(e);
    }

    public void succeed(V result) {
        this.set(result);
    }

    protected static ByteBuf toBuffer(ByteBufAllocator alloc, ByteBuffer dst, int extra) {
        dst.flip();
        ByteBuf buffer = alloc.buffer(dst.remaining() + extra);
        buffer.writeBytes(dst);
        return buffer;
    }

    public abstract void handle(Object var1) throws IOException;

    public int getOpaque() {
        return this.opaque;
    }

    @VisibleForTesting
    static byte[] encodeKey(String key, Charset charset) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)charset, (Object)"charset");
        byte[] keyBytes = key.getBytes(charset);
        int length = keyBytes.length;
        if (length > 250) {
            throw new IllegalArgumentException("Key is too long: " + key);
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Key is empty");
        }
        for (int i = 0; i < length; ++i) {
            byte c = keyBytes[i];
            if (c < 0 || c > 32) continue;
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        return keyBytes;
    }

    protected static List<byte[]> encodeKeys(List<String> keys, Charset charset) {
        ArrayList res = Lists.newArrayListWithCapacity((int)keys.size());
        for (String key : keys) {
            res.add(Request.encodeKey(key, charset));
        }
        return res;
    }
}

